function res = LEM_sim1_LBSD(num_flights,b)
% LEM_sim1_LBSD - basic small-scale simulation of lane based method
% On input:
%     num_flights (int): number of flights
%     b (Boolean): make movie
% On output:
%     res (results struct): results info
%       .roads (roads struct): roads info
%       .airways (airways struct): airways info
%       .requests (requests struct): LBSD requests
%       .reservations (reservations struct): reservations info
%       .flights (flights struct): flights info
%       .failures_LBSD (n by 1 vector): 0 if LBSD flight success; else 1
%       .flights_cells (flights struct): cells flight info
%       .cells (cells struct): FAA-NASA cells corresponding to LBSD layout
%       .requests_cells (requests_cells struct): FAA-NASA flight requests 
%       .P (nx5 array): performance info for LBSD
%         col 1 (float): flight ID
%         col 2 (float): delay (actual_start - requested_min_start)
%         col 3 (float): flight duration
%         col 4 (float): deconflict time
%         col 5 (float): failed to schedule
% Call:
%     res = LEM_sim1_LBSD(500,0);
% Author:
%     T. Henderson
%     UU
%     Fall 2020
%

FAILED = 0;

res = [];

rng('default');
roads = LEM_gen_grid_roads(0,50,0,50,10,10);
launch_sites = [1:6];
land_sites = [31:36];
airways = LEM_gen_airways(roads,launch_sites,land_sites,2,467,534);
hd = 1;   % headway distance
t_min = 0;
t_max = 100;
launch_time_interval = 120;
min_speed = 10;
max_speed = 10;
%num_flights = 100;
requests = LEM_gen_requests_LBSD(t_min,t_max,airways,num_flights,...
    launch_time_interval,[min_speed,max_speed]);
[reservations,flights] = LEM_requests2reservations(airways,requests,hd);

del_t = 0.1;
for f = 1:num_flights
    f_out = LEM_gen_traj(flights(f),del_t);
    flights(f).traj = f_out.traj;
end

if b==1
    LEM_run_flights(airways,flights,1,1,'sim1_LBSD');
end

P_LBSD = LEM_performance(flights);

res.roads = roads;
res.airways = airways;
res.requests = requests;
res.reservations = reservations;
res.flights = flights;
failures_LBSD = zeros(num_flights,1);
for f = 1:num_flights
    if flights(f).type==FAILED
        failures_LBSD(f) = 1;
    end
end
res.failures_LBSD = failures_LBSD;
res.mp4 = 'sim1_LBSD.mp4';
res.P_LBSD = P_LBSD;
res.P_cells = [];
