function [trace,score] = CS4300_WW_sim(max_steps,f_name,board)
% CS4300_WW_sim - Wumpus World 1 simulator
% On input:
%     max_steps (int): maximum number of simulation steps
%     f_name (string): name of agent function
%     board (4x4 array): Wumpus world board
% On output:
%     trace (nx3 int array): trace of state
%       (i,1): x location
%       (i,2): y location
%       (i,3): action selected at time i
%     score (int): final score for agent
% Call:
%     board = CS4300_gen_board(0.2);
%     [t,s] = CS4300_WW_sim(5,'CS4300_random_agent',board);
%     CS4300_show_trace(t,0.1);
% Author:
%     T. Henderson
%     UU
%     Summer 2015/Spring 2022
%

FORWARD = 1;
RIGHT = 2;
LEFT = 3;
GRAB = 4;
SHOOT = 5;
CLIMB = 6;

score = 0;

agent.x = 1;
agent.y = 1;
agent.alive = 1;  
agent.gold = 0;  % grabbed gold in same room
agent.dir = 0;  % facing right
agent.succeed = 0;  % has gold and climbed out
agent.climbed = 0; % climbed out

trace(1).board = board;
trace(1).agent = agent;
trace(1).action = 0;

step = 0;
done = 0;
bumped = 0;
screamed = 0;
clear(f_name);
fclose('all');

while step<max_steps&done==0
    step = step + 1;
    percept = CS4300_get_percept(board,agent,bumped,screamed);
    try
        action = feval(f_name,percept);
    catch
        pause(3);
        action = feval(f_name,percept);
    end
    [board,agent,bumped,screamed] = CS4300_update(board,agent,action);
    trace(step+1).agent = agent;
    trace(step+1).board = board;
    trace(step+1).action = action;
    if agent.alive==1
        if action==SHOOT
            score = score - 5;
        else
            score = score -1;
        end
        if agent.succeed==1
            score = score + 1000;
        end
    else
        score = score - 1000;
    end
    if agent.alive==0|agent.succeed==1|agent.climbed==1
        done = 1;
    end
end
