// ping-pong-gather
// by Mario Irizarry
// July 19, 2004
// 2004 SROP - Summer Research Opportunity Program
// for mentors Dr. Martin Berzins and Dr. Mike Kirby
// at the Scientific Computing and Imaging Institute - SCI Institute
// at the University of Utah, Salt Lake City, UT

// the purpose of this program is for 2 nodes at a time
// to play ping-pong with the MPI_Gather
// instruction to determine execution times
// among different amount of processors.
// number of cycles to be run are 100, 1000, 10000, 100000.

#include<iostream>
#include "mpi.h"

using namespace std;

int main(int argc, char ** argv)
{
  int mynode, totalnodes;  // declare node variables.
  int datasize = 1;  // num of data units to be processed.
  int count;  // initialize accumulators and counter.
  int numtests = 4;  // number of test cycles.

  double starttime, finaltime;  // declare timing variables.
  int numofcycles[4];  // declare cycles array.

  numofcycles[0] = 100;  // initialize cycle variables.
  numofcycles[1] = 1000;
  numofcycles[2] = 10000;
  numofcycles[3] = 100000;

//  MPI_Status status;

  MPI_Init(&argc, &argv);
  MPI_Comm_size(MPI_COMM_WORLD, &totalnodes);  // get totalnodes
  MPI_Comm_rank(MPI_COMM_WORLD, &mynode);  // get mynodes

  double * senddata = new double[datasize * totalnodes];
  double * recvdata = new double[datasize * totalnodes];

  for(int x = 0; x < numtests; x++){  // test cycles.

    MPI_Barrier(MPI_COMM_WORLD);
    starttime = MPI_Wtime();        // take start time for each test cycle.

    count = 0;  // initialize variable for each test cycle.
    for(int i = 0; i < numofcycles[x]; i++){          // test cycle.
        for(int j = 0; j < totalnodes; j++){          // determine nnode to gather to.
            MPI_Gather(senddata, datasize, MPI_DOUBLE, recvdata, datasize, MPI_DOUBLE, j, MPI_COMM_WORLD);
            count++;
        }
    }

    MPI_Barrier(MPI_COMM_WORLD);
    finaltime = MPI_Wtime();        // take final time for each test cycle.
    if(mynode == 0)            // output per test cycle.
      cout << totalnodes << ", " << numofcycles[x] << ", " << count << ", "
	              << (finaltime - starttime)/count << endl;
  }
  MPI_Finalize();

}
