// ping-pong-allreduce
// by Mario Irizarry
// July 20, 2004
// 2004 SROP - Summer Research Opportunity Program
// for mentors Dr. Martin Berzins and Dr. Mike Kirby
// at the Scientific Computing and Imaging Institute - SCI Institute
// at the University of Utah, Salt Lake City, UT

// the purpose of this program is for 2 nodes at a time
// to play ping-pong with the MPI_Allreduce
// instruction to determine execution times
// among different amount of processors.
// number of cycles to be run are 100, 1000, 10000, 100000.

#include<iostream>
#include "mpi.h"

using namespace std;

int main(int argc, char ** argv)
{
  int mynode, totalnodes;  // declare node variables.
  int sum = 0, accum = 0, count = 0;  // initialize accumulators and counter.
  int numtests = 4;  // number of test cycles.
  double starttime, finaltime;  // declare timing variables.
  double numofcycles[4];  // declare cycles array.

  numofcycles[0] = 100;  // initialize cycle variables.
  numofcycles[1] = 1000;
  numofcycles[2] = 10000;
  numofcycles[3] = 100000;

//  MPI_Status status;

  MPI_Init(&argc, &argv);
  MPI_Comm_size(MPI_COMM_WORLD, &totalnodes);  // get totalnodes
  MPI_Comm_rank(MPI_COMM_WORLD, &mynode);  // get mynodes
 
  for(int x = 0; x < numtests; x++){  // test cycles.

    MPI_Barrier(MPI_COMM_WORLD);
    starttime = MPI_Wtime();        // take start time for each test cycle.

    count = 0;  // initialize variable for each test cycle.
    for(int i = 0; i < numofcycles[x]; i++){          // test cycle.
        MPI_Allreduce(&sum, &accum, 1, MPI_INT, MPI_SUM, MPI_COMM_WORLD);
        count++;
    }

    MPI_Barrier(MPI_COMM_WORLD);
    finaltime = MPI_Wtime();        // take final time for each test cycle.
    if(mynode == 0)            // output per test cycle.
      cout << totalnodes << ", " << numofcycles[x] << ", " << count << ", "
	              << (finaltime - starttime)/count << endl;
  }
  MPI_Finalize();

}
