(module webmathematica mzscheme
  
  (require (lib "class.ss")
           (lib "servlet.ss" "web-server")
           (lib "response.ss" "web-server")
           (lib "mathematica.ss" "mrmathematica")
           "pool.scm")
  
  (provide interface-version timeout start)
  (define interface-version 'v1)
  (define timeout +inf.0)
  
  (define synchronizeeval
    (let ((pool
           (instantiate pool%
             ((vector (MathKernel) (MathKernel))))))
      (lambda (exp)
        (send pool call-with-pool MathEval exp))))
  
  (define random-example
    (let ((examples
           (vector "1/(5 x + 8)"
                   "1/(x^2 + 9 x + 4)"
                   "1/(18 - x^2)"
                   "x/(4 x + 2)"
                   "x/(x^2 + 9 x + 4)"
                   "x/(4 x + 2)^2"
                   "x^2/(4 x + 2)^2"
                   "E^(3 x) Sin[5 x + 7]"
                   "E^(3 x) Cos[5 x + 7]"
                   "E^(3 x) Sinh[5 x + 7]"
                   "E^(3 x) Cosh[5 x + 7]"
                   "(2 x + 1)/(5 x + 8)^3"
                   "(2 x + 1)^2/(5 x + 8)^3"
                   "(3 x + 7)/(x^3 - 1)"
                   "(3 x + 7)^3/(x^3 - 1)^3"
                   "Sqrt[x - 1]/(1 + Sqrt[2 x])"
                   "Sqrt[x - 1]/(2 + 3 x)^2"
                   "Sqrt[x - 1]/(2 + 3 x)^3"
                   "Log[3 x + 6]"
                   "Log[10, x]"
                   "Cos[Sqrt[2 - 3 x]]"
                   "Sqrt[Tan[x]]"
                   "1/Sqrt[x^2 - 9 x + 3]"
                   "1/(Sqrt[x^2 - 1] + 4)"
                   "1/(x^3 + 1)^4"
                   "x ArcSin[x]"
                   "x ArcCos[x]"
                   "x ArcTan[x]"
                   "x ArcCot[x]"
                   "a^x Log[a]"
                   "1/(a^2 + x^2)"
                   "1/(a^2 - x^2)"
                   "1/(-a^2 + x^2)"
                   "1/Sqrt[a^2 - x^2]"
                   "1/Sqrt[a^2 + x^2]"
                   "1/Sqrt[-a^2 + x^2]"
                   "1/(x Sqrt[-a^2 + x^2])"
                   "1/(x Sqrt[a^2 + x^2])"
                   "1/(x Sqrt[a^2 - x^2])"
                   "(a + b x)^n"
                   "x (a + b x)^n"
                   "x^2 (a + b x)^n"
                   "x^m (a + b x)^n"
                   "1/(a + b x)"
                   "(a + b x)^(-2)"
                   "(a + b x)^(-3)"
                   "x/(a + b x)"
                   "x/(a + b x)^2"
                   "x/(a + b x)^n"
                   "x^2/(a + b x)"
                   "x^2/(a + b x)^2"
                   "x^2/(a + b x)^3"
                   "x^2/(a + b x)^n"
                   "1/(x (a + b x))"
                   "1/(x (a + b x)^2)"
                   "1/(x (a + b x)^3)"
                   "1/(x^2 (a + b x))"
                   "1/(x^3 (a + b x))"
                   "1/(x^2 (a + b x)^2)"
                   "1/(c^2 + x^2)"
                   "1/(c^2 - x^2)"
                   "1/(-c^2 + x^2)"
                   "x/(c^2 + x^2)"
                   "x/(c^2 - x^2)"
                   "x (c^2 + x^2)^(-1 - n)"
                   "x (c^2 - x^2)^(-1 - n)"
                   "(c^2 + x^2)^(-n)"
                   "(c^2 - x^2)^(-n)"
                   "(-c^2 + x^2)^(-n)"
                   "x/(-c^2 + x^2)"
                   "x (-c^2 + x^2)^(-1 - n)"
                   "1/((a + b x) (c + d x))"
                   "x/((a + b x) (c + d x))"
                   "1/((a + b x)^2 (c + d x))"
                   "x/((a + b x)^2 (c + d x))"
                   "x^2/((a + b x)^2 (c + d x))"
                   "1/((a + b x)^n (c + d x)^m)"
                   "(a + b x)/(c + d x)"
                   "(a + b x)^m/(c + d x)^n"
                   "1/(a + b x^2)"
                   "1/(a^2 + b^2 x^2)"
                   "x/(a + b x^2)"
                   "x^2/(a + b x^2)"
                   "(a + b x^2)^(-2)"
                   "1/(a^2 - b^2 x^2)"
                   "(a + b x^2)^(-1 - m)"
                   "x (a + b x^2)^(-1 - m)"
                   "x^2 (a + b x^2)^(-1 - m)"
                   "1/(x (a + b x^2))"
                   "1/(x^2 (a + b x^2))"
                   "(a + b x^2)^(-1 - m)/x"
                   "(a + b x^2)^(-1 - m)/x^2"
                   "1/(a + b x^3)"
                   "x/(a + b x^3)"
                   "x^2/(a + b x^3)"
                   "1/(a + b x^4)"
                   "x/(a + b x^4)"
                   "x^2/(a + b x^4)"
                   "x^2/(a + b x^4)"
                   "x^3/(a + b x^4)"
                   "1/(x (a + b x^n))"
                   "(a + b x^n)^(-1 - m)"
                   "x^m (a + b x^n)^(-1 - p)"
                   "(a + b x^n)^(-1 - p)/x^m"
                   "x^m (a + b x^n)^p"
                   "1/(c^3 + x^3)"
                   "1/(c^3 - x^3)"
                   "(c^3 + x^3)^(-2)"
                   "(c^3 - x^3)^(-2)"
                   "(c^3 + x^3)^(-1 - n)"
                   "(c^3 - x^3)^(-1 - n)"
                   "x/(c^3 + x^3)"
                   "x/(c^3 - x^3)"
                   "x/(c^3 + x^3)^2"
                   "x/(c^3 - x^3)^2"
                   "x (c^3 + x^3)^(-1 - n)"
                   "x (c^3 - x^3)^(-1 - n)"
                   "x^2/(c^3 + x^3)"
                   "x^2/(c^3 - x^3)"
                   "x^2 (c^3 + x^3)^(-1 - n)"
                   "x^2 (c^3 - x^3)^(-1 - n)"
                   "1/(x (c^3 + x^3))"
                   "1/(x (c^3 - x^3))"
                   "1/(x (c^3 + x^3)^2)"
                   "1/(x (c^3 - x^3)^2)"
                   "(c^3 + x^3)^(-1 - n)/x"
                   "(c^3 - x^3)^(-1 - n)/x"
                   "1/(x^2 (c^3 + x^3))"
                   "1/(x^2 (c^3 - x^3))"
                   "(c^3 + x^3)^(-1 - n)/x^2"
                   "(c^3 - x^3)^(-1 - n)/x^2"
                   "1/(c^4 + x^4)"
                   "1/(c^4 - x^4)"
                   "x/(c^4 + x^4)"
                   "x/(c^4 - x^4)"
                   "x^2/(c^4 + x^4)"
                   "x^2/(c^4 - x^4)"
                   "x^3/(c^4 + x^4)"
                   "x^3/(c^4 - x^4)"
                   "1/(a + b x + c x^2)"
                   "(a + b x + c x^2)^(-2)"
                   "(a + b x + c x^2)^(-3)"
                   "(a + b x + c x^2)^(-1 - n)"
                   "x/(a + b x + c x^2)"
                   "x/(a + b x + c x^2)^2"
                   "x^2/(a + b x + c x^2)"
                   "x^2/(a + b x + c x^2)^2"
                   "1/(x (a + b x + c x^2))"
                   "1/(x^2 (a + b x + c x^2))"
                   "Sqrt[a + b x]"
                   "x Sqrt[a + b x]"
                   "x^2 Sqrt[a + b x]"
                   "x^m Sqrt[a + b x]"
                   "Sqrt[a + b x]/x"
                   "Sqrt[a + b x]/x^2"
                   "Sqrt[a + b x]/x^m"
                   "1/Sqrt[a + b x]"
                   "x/Sqrt[a + b x]"
                   "x^2/Sqrt[a + b x]"
                   "x^m/Sqrt[a + b x]"
                   "1/(x Sqrt[a + b x])"
                   "1/(x Sqrt[a + b x])"
                   "1/(x^2 Sqrt[a + b x])"
                   "1/(x^n Sqrt[a + b x])"
                   "(a + b x)^(n/2)"
                   "(a + b x)^(-(n/2))"
                   "x (a + b x)^(n/2)"
                   "x/(a + b x)^(n/2)"
                   "1/(x (a + b x)^(m/2))"
                   "(a + b x)^(n/2)/x"
                   "1/Sqrt[(a + b x) (c + d x)]"
                   "Sqrt[(a + b x) (c + d x)]"
                   "1/(Sqrt[a + b x] (c + d x))"
                   "x/Sqrt[(a + b x) (c + d x)]"
                   "(c+d x)/Sqrt[(a+b x) (c+d x)]"
                   "Sqrt[(c + d x)/(a + b x)]"
                   "Sqrt[a + b x] (c + d x)^m"
                   "1/(Sqrt[a + b x] (c + d x)^m)"
                   "(c + d x)^m/Sqrt[a + b x]"
                   "Sqrt[a^2 + x^2]"
                   "Sqrt[-a^2 + x^2]"
                   "1/Sqrt[a^2 + x^2]"
                   "1/Sqrt[-a^2 + x^2]"
                   "Sqrt[a^2 + x^2]/x"
                   "Sqrt[-a^2 + x^2]/x"
                   "x/Sqrt[a^2 + x^2]"
                   "x/Sqrt[-a^2 + x^2]"
                   "x Sqrt[a^2 + x^2]"
                   "x Sqrt[-a^2 + x^2]"
                   "Sqrt[(a^2 + x^2)^3]"
                   "Sqrt[(-a^2 + x^2)^3]"
                   "(a^2 + x^2)^(-3/2)"
                   "(-a^2 + x^2)^(-3/2)"
                   "x/(a^2 + x^2)^(3/2)"
                   "x/(-a^2 + x^2)^(3/2)"
                   "x (a^2 + x^2)^(3/2)"
                   "x (-a^2 + x^2)^(3/2)"
                   "x^2 Sqrt[a^2 + x^2]"
                   "x^2 Sqrt[-a^2 + x^2]"
                   "x^3 Sqrt[a^2 + x^2]"
                   "x^3 Sqrt[-a^2 + x^2]"
                   "x^2/Sqrt[a^2 + x^2]"
                   "x^2/Sqrt[-a^2 + x^2]"
                   "x^3/Sqrt[a^2 + x^2]"
                   "x^3/Sqrt[-a^2 + x^2]"
                   "1/(x^2 Sqrt[a^2 + x^2])"
                   "1/(x^2 Sqrt[-a^2 + x^2])"
                   "1/(x^3 Sqrt[a^2 + x^2])"
                   "1/(x^3 Sqrt[-a^2 + x^2])"
                   "x^2 (a^2 + x^2)^(3/2)"
                   "x^2 (-a^2 + x^2)^(3/2)"
                   "x^3 (a^2 + x^2)^(3/2)"
                   "x^3 (-a^2 + x^2)^(3/2)"
                   "Sqrt[a^2 + x^2]/x^2"
                   "Sqrt[-a^2 + x^2]/x^2"
                   "Sqrt[a^2 + x^2]/x^3"
                   "Sqrt[-a^2 + x^2]/x^3"
                   "Sqrt[a^2 + x^2]/x^4"
                   "Sqrt[-a^2 + x^2]/x^4"
                   "x^2/(a^2 + x^2)^(3/2)"
                   "x^2/(-a^2 + x^2)^(3/2)"
                   "x^3/(a^2 + x^2)^(3/2)"
                   "x^3/(-a^2 + x^2)^(3/2)"
                   "1/(x (a^2 + x^2)^(3/2))"
                   "1/(x (-a^2 + x^2)^(3/2))"
                   "1/(x^2 (a^2 + x^2)^(3/2))"
                   "1/(x^2 (-a^2 + x^2)^(3/2))"
                   "1/(x^3 (a^2 + x^2)^(3/2))"
                   "1/(x^3 (-a^2 + x^2)^(3/2))"
                   "x^m/Sqrt[a^2 + x^2]"
                   "x^m/Sqrt[-a^2 + x^2]"
                   "x^(2 m)/Sqrt[a^2 + x^2]"
                   "x^(2 m)/Sqrt[-a^2 + x^2]"
                   "x^(1 + 2 m)/Sqrt[a^2 + x^2]"
                   "x^(1 + 2 m)/Sqrt[-a^2 + x^2]"
                   "1/(x^m Sqrt[a^2 + x^2])"
                   "1/(x^m Sqrt[-a^2 + x^2])"
                   "1/(x^(2 m) Sqrt[a^2 + x^2])"
                   "1/(x^(2 m) Sqrt[-a^2 + x^2])"
                   "x^(-1 - 2 m)/Sqrt[a^2 + x^2]"
                   "x^(-1 - 2 m)/Sqrt[-a^2 + x^2]"
                   "1/((-a + x) Sqrt[-a^2 + x^2])"
                   "1/((a + x) Sqrt[-a^2 + x^2])"
                   "Sqrt[a^2 - x^2]"
                   "Sqrt[a^2 - x^2]/x"
                   "x/Sqrt[a^2 - x^2]"
                   "x Sqrt[a^2 - x^2]"
                   "Sqrt[(a^2 - x^2)^3]"
                   "1/Sqrt[(a^2 - x^2)^3]"
                   "x/Sqrt[(a^2 - x^2)^3]"
                   "x Sqrt[(a^2 - x^2)^3]"
                   "x^2 Sqrt[a^2 - x^2]"
                   "x^3 Sqrt[a^2 - x^2]"
                   "x^2 Sqrt[(a^2 - x^2)^3]"
                   "x^3 Sqrt[(a^2 - x^2)^3]"
                   "x^2/Sqrt[a^2 - x^2]"
                   "1/(x^2 Sqrt[a^2 - x^2])"
                   "Sqrt[a^2 - x^2]/x^2"
                   "Sqrt[a^2 - x^2]/x^3"
                   "Sqrt[a^2 - x^2]/x^4"
                   "x^2/Sqrt[(a^2 - x^2)^3]"
                   "x^3/Sqrt[a^2 - x^2]"
                   "x^3/Sqrt[(a^2 - x^2)^3]"
                   "1/(x^3 Sqrt[a^2 - x^2])"
                   "1/(x Sqrt[(a^2 - x^2)^3])"
                   "1/(x^2 Sqrt[(a^2 - x^2)^3])"
                   "1/(x^3 Sqrt[(a^2 - x^2)^3])"
                   "x^m/Sqrt[a^2 - x^2]"
                   "x^(2 m)/Sqrt[a^2 - x^2]"
                   "x^(1 + 2 m)/Sqrt[a^2 - x^2]"
                   "1/(x^m Sqrt[a^2 - x^2])"
                   "1/(x^(2 m) Sqrt[a^2 - x^2])"
                   "x^(-1 - 2 m)/Sqrt[a^2 - x^2]"
                   "1/(Sqrt[a^2-x^2] (b^2-x^2))"
                   "1/(Sqrt[a^2-x^2] (b^2+x^2))"
                   "Sqrt[a^2 - x^2]/(b^2 + x^2)"
                   "1/Sqrt[a + b x + c x^2]"
                   "(a + b x + c x^2)^(-3/2)"
                   "(a + b x + c x^2)^(-5/2)"
                   "(a+b x+c x^2)^(-2^(-1)-n)"
                   "Sqrt[a + b x + c x^2]"
                   "(a + b x + c x^2)^(3/2)"
                   "(a + b x + c x^2)^(5/2)"
                   "(a + b x + c x^2)^(1/2 + n)"
                   "x/Sqrt[a + b x + c x^2]"
                   "x/(a + b x + c x^2)^(3/2)"
                   "x^2/Sqrt[a + b x + c x^2]"
                   "x^2/(a + b x + c x^2)^(3/2)"
                   "x^3/Sqrt[a + b x + c x^2]"
                   "x Sqrt[a + b x + c x^2]"
                   "x (a + b x + c x^2)^(3/2)"
                   "x (a + b x + c x^2)^2"
                   "x^2 Sqrt[a + b x + c x^2]"
                   "1/(x Sqrt[a + b x + c x^2])"
                   "1/(x^2 Sqrt[a + b x + c x^2])"
                   "Sqrt[a + b x + c x^2]/x"
                   "Sqrt[a + b x + c x^2]/x^2"
                   "Sqrt[2 a x - x^2]"
                   "1/Sqrt[2 a x - x^2]"
                   "x^n Sqrt[2 a x - x^2]"
                   "x^(3/2) Sqrt[2 a x - x^2]"
                   "x^9 Sqrt[2 a x - x^2]"
                   "Sqrt[2 a x - x^2]/x^n"
                   "x^n/Sqrt[2 a x - x^2]"
                   "1/(x^n Sqrt[2 a x - x^2])"
                   "(2 a x - x^2)^(-3/2)"
                   "x/(2 a x - x^2)^(3/2)"
                   "1/Sqrt[2 a x + x^2]"
                   "Sqrt[c + a x^2]"
                   "Sqrt[(1 + x)/(1 - x)]"
                   "1/(x Sqrt[c + a x^n])"
                   "1/Sqrt[c + a x^2]"
                   "(c + a x^2)^(1/2 + m)"
                   "x (c + a x^2)^(1/2 + m)"
                   "(c + a x^2)^(1/2 + m)/x"
                   "x (c + a x^2)^(3/2)"
                   "x (c + a x^2)^(7/3)"
                   "(c + a x^2)^(-2^(-1) - m)"
                   "1/(x^m Sqrt[c + a x^2])"
                   "(c + a x^2)^(-3/2)"
                   "(c + a x^2)^(-7/5)"
                   "1/(x^m Sqrt[c + a x^2])"
                   "(1+x^2)/((1-x^2) Sqrt[1+x^4])"
                   "(1-x^2)/((1+x^2) Sqrt[1+x^4])"
                   "1/(x Sqrt[a^2 + x^n])"
                   "1/(x Sqrt[-a^2 + x^n])"
                   "Sqrt[x/(a^3 - x^3)]"
                   "Sin[a x]"
                   "Cos[a x]"
                   "Tan[a x]"
                   "Cot[a x]"
                   "Sec[a x]"
                   "Csc[a x]"
                   "Sin[a x]^2"
                   "Sin[a x]^3"
                   "Sin[a x]^4"
                   "Sin[a x]^n"
                   "Sin[a x]^(2 m)"
                   "Sin[a x]^(1 + 2 m)"
                   "Cos[a x]^2"
                   "Cos[a x]^3"
                   "Cos[a x]^4"
                   "Cos[a x]^n"
                   "Cos[a x]^(2 m)"
                   "Cos[a x]^(1 + 2 m)"
                   "Csc[a x]^2"
                   "Sin[a x]^(-m)"
                   "Sin[a x]^(-2 m)"
                   "Sin[a x]^(-1 - 2 m)"
                   "Sec[a x]^2"
                   "Cos[a x]^(-n)"
                   "Cos[a x]^(-2 m)"
                   "Cos[a x]^(-1 - 2 m)"
                   "Sin[m x] Sin[n x]"
                   "Cos[m x] Cos[n x]"
                   "Cos[a x] Sin[a x]"
                   "Cos[n x] Sin[m x]"
                   "Cos[a x]^2 Sin[a x]^2"
                   "Cos[a x]^m Sin[a x]"
                   "Cos[a x] Sin[a x]^m"
                   "Cos[a x]^m Sin[a x]^n"
                   "Cos[a x]^m/Sin[a x]^n"
                   "Sin[a x]^m/Cos[a x]^n"
                   "Sec[a x] Tan[a x]"
                   "Sin[a x] Tan[a x]"
                   "Cot[a x] Csc[a x]"
                   "Csc[a x] Sec[a x]"
                   "Csc[a x] Sec[a x]^2"
                   "Csc[a x]/Cos[a x]^n"
                   "Csc[a x]^2 Sec[a x]"
                   "Csc[a x]^2 Sec[a x]^2"
                   "1/(Cos[a x]^n Sin[a x]^m)"
                   "Sin[a + b x]"
                   "Cos[a + b x]"
                   "1/(1 + Sin[a x])"
                   "1/(1 - Sin[a x])"
                   "1/(1 + Cos[a x])"
                   "1/(1 - Cos[a x])"
                   "1/(a + b Sin[x])"
                   "1/(a + b Cos[x])"
                   "1/(a + c Cos[x] + b Sin[x])"
                   "Sin[x]^2/(a + b Cos[x]^2)"
                   "1/(a^2 Cos[x]^2+b^2 Sin[x]^2)"
                   "Sin[a x]/(1 + Sin[a x])"
                   "Sin[a x]/(1 - Sin[a x])"
                   "Csc[a x]/(1 + Sin[a x])"
                   "Csc[a x]/(1 - Sin[a x])"
                   "(1 + Sin[a x])^(-2)"
                   "(1 - Sin[a x])^(-2)"
                   "Sin[a x]/(1 + Sin[a x])^2"
                   "Sin[a x]/(1 - Sin[a x])^2"
                   "Sin[x]/(a + b Sin[x])"
                   "Csc[x]/(a + b Sin[x])"
                   "(a + b Sin[x])^(-2)"
                   "Sin[x]/(a + b Sin[x])^2"
                   "1/(a^2 + b^2 Sin[c x]^2)"
                   "1/(a^2 - b^2 Sin[c x]^2)"
                   "Cos[a x]/(1 + Cos[a x])"
                   "Cos[a x]/(1 - Cos[a x])"
                   "Sec[a x]/(1 + Cos[a x])"
                   "Sec[a x]/(1 - Cos[a x])"
                   "(1 + Cos[a x])^(-2)"
                   "(1 - Cos[a x])^(-2)"
                   "Cos[a x]/(1 + Cos[a x])^2"
                   "Cos[a x]/(1 - Cos[a x])^2"
                   "Cos[x]/(a + b Cos[x])"
                   "Sec[x]/(a + b Cos[x])"
                   "(a + b Cos[x])^(-2)"
                   "Cos[x]/(a + b Cos[x])^2"
                   "1/(a^2 + b^2 - 2 a b Cos[c x])"
                   "1/(a^2 + b^2 Cos[c x]^2)"
                   "1/(a^2 - b^2 Cos[c x]^2)"
                   "Sin[a x]/(1 + Cos[a x])"
                   "Sin[a x]/(1 - Cos[a x])"
                   "Cos[a x]/(1 + Sin[a x])"
                   "Cos[a x]/(1 - Sin[a x])"
                   "Csc[a x]/(1 + Cos[a x])"
                   "Csc[a x]/(1 - Cos[a x])"
                   "Sec[a x]/(1 + Sin[a x])"
                   "Sec[a x]/(1 - Sin[a x])"
                   "Tan[a x]/(1 + Cos[a x])"
                   "Tan[a x]/(1 - Cos[a x])"
                   "Cot[a x]/(1 + Sin[a x])"
                   "Cot[a x]/(1 - Sin[a x])"
                   "Tan[a x]/(1 + Sin[a x])"
                   "Tan[a x]/(1 - Sin[a x])"
                   "Cot[a x]/(1 + Cos[a x])"
                   "Cot[a x]/(1 - Cos[a x])"
                   "1/(Cos[a x] + Sin[a x])"
                   "1/(-Cos[a x] + Sin[a x])"
                   "(Cos[a x] + Sin[a x])^(-2)"
                   "(-Cos[a x] + Sin[a x])^(-2)"
                   "1/(1 + Cos[a x] + Sin[a x])"
                   "1/(1 + Cos[a x] - Sin[a x])"
                   "x Sin[a x]"
                   "x^2 Sin[a x]"
                   "x^3 Sin[a x]"
                   "x^m Sin[a x]"
                   "x Cos[a x]"
                   "x^2 Cos[a x]"
                   "x^3 Cos[a x]"
                   "x^m Cos[a x]"
                   "Sin[a x]/x"
                   "Cos[a x]/x"
                   "x Sin[a x]^2"
                   "x^2 Sin[a x]^2"
                   "x Sin[a x]^3"
                   "x Cos[a x]^2"
                   "x^2 Cos[a x]^2"
                   "x Cos[a x]^3"
                   "Sin[a x]/x^m"
                   "Cos[a x]/x^m"
                   "x/(1 + Sin[a x])"
                   "x/(1 - Sin[a x])"
                   "x/(1 + Cos[a x])"
                   "x/(1 - Cos[a x])"
                   "(x + Sin[x])/(1 + Cos[x])"
                   "(x - Sin[x])/(1 - Cos[x])"
                   "Sqrt[1 - Cos[a x]]"
                   "Sqrt[1 + Cos[a x]]"
                   "Sqrt[1 + Sin[x]]"
                   "Sqrt[1 - Sin[x]]"
                   "1/Sqrt[1 - Cos[x]]"
                   "1/Sqrt[1 + Cos[x]]"
                   "1/Sqrt[1 - Sin[x]]"
                   "1/Sqrt[1 + Sin[x]]"
                   "Tan[a x]^2"
                   "Tan[a x]^3"
                   "Tan[a x]^4"
                   "Tan[a x]^n"
                   "Cot[a x]^2"
                   "Cot[a x]^3"
                   "Cot[a x]^4"
                   "Cot[a x]^n"
                   "x Csc[a x]^2"
                   "x/Sin[a x]^n"
                   "x Sec[a x]^2"
                   "x/Cos[a x]^n"
                   "1/Sqrt[a + b Tan[c x]^2]"
                   "ArcSin[a x]"
                   "ArcCos[a x]"
                   "ArcTan[a x]"
                   "ArcCot[a x]"
                   "ArcSec[a x]"
                   "ArcCsc[a x]"
                   "ArcSin[x/a]"
                   "ArcCos[x/a]"
                   "ArcTan[x/a]"
                   "ArcCot[x/a]"
                   "x ArcSin[a x]"
                   "x ArcCos[a x]"
                   "x^n ArcSin[a x]"
                   "x^n ArcCos[a x]"
                   "x ArcTan[a x]"
                   "x^n ArcTan[a x]"
                   "x ArcCot[a x]"
                   "x^n ArcCot[a x]"
                   "ArcSin[a x]/x^2"
                   "ArcCos[a x]/x^2"
                   "ArcTan[a x]/x^2"
                   "ArcCot[a x]/x^2"
                   "ArcSin[a x]^2"
                   "ArcCos[a x]^2"
                   "ArcSin[a x]^n"
                   "ArcCos[a x]^n"
                   "ArcSin[a x]/Sqrt[1 - a^2 x^2]"
                   "ArcCos[a x]/Sqrt[1 - a^2 x^2]"
                   "ArcTan[a x]/(1 + a^2 x^2)"
                   "ArcCot[a x]/(1 + a^2 x^2)"
                   "x ArcSec[a x]"
                   "x^n ArcSec[a x]"
                   "ArcSec[a x]/x^2"
                   "x ArcCsc[a x]"
                   "x^n ArcCsc[a x]"
                   "ArcCsc[a x]/x^2"
                   "x Log[x]"
                   "x^2 Log[x]"
                   "x^n Log[a x]"
                   "Log[x]^2"
                   "Log[x]^n"
                   "Log[x]^n/x"
                   "1/Log[x]"
                   "1/(x Log[x])"
                   "1/(x Log[x]^n)"
                   "x^m/Log[x]^n"
                   "x^m Log[x]^n"
                   "x^p Cos[b Log[x]]"
                   "x^p Sin[b Log[x]]"
                   "Log[b + a x]"
                   "Log[b + a x]/x^2"
                   "x^m Log[b + a x]"
                   "Log[b + a x]/x^m"
                   "Log[(a + x)/(-a + x)]"
                   "x^m Log[(a + x)/(-a + x)]"
                   "Log[(a + x)/(-a + x)]/x^2"
                   "Log[a + b x + c x^2]"
                   "x^n Log[a + b x + c x^2]"
                   "Log[a^2 + x^2]"
                   "Log[-a^2 + x^2]"
                   "x Log[-a^2 + x^2]"
                   "x Log[a^2 + x^2]"
                   "Log[x + Sqrt[a^2 + x^2]]"
                   "Log[x + Sqrt[-a^2 + x^2]]"
                   "x Log[x + Sqrt[a^2 + x^2]]"
                   "x Log[x + Sqrt[-a^2 + x^2]]"
                   "x^m Log[x + Sqrt[a^2 + x^2]]"
                   "x^m Log[x + Sqrt[-a^2 + x^2]]"
                   "Log[x + Sqrt[a^2 + x^2]]/x^2"
                   "Log[x + Sqrt[-a^2 + x^2]]/x^2"
                   "x^n Log[-a^2 + x^2]"
                   "E^(a x) x"
                   "E^(a x) x^m"
                   "E^(a x)/x"
                   "E^(a x)/x^m"
                   "E^(a x) Log[x]"
                   "1/(1 + E^x)"
                   "1/(a + b E^(p x))"
                   "1/(b/E^(m x) + a E^(m x))"
                   "1/(-(b/E^(m x)) + a E^(m x))"
                   "-a^(-x) + a^x"
                   "E^(a x)/(b + c E^(a x))"
                   "(E^(a x) x)/(1 + a x)^2"
                   "E^(a x) Sin[b x]"
                   "E^(a x) Sin[b x] Sin[c x]"
                   "E^(a x) Cos[c x] Sin[b x]"
                   "E^(a x) Sin[b x] Sin[c + b x]"
                   "E^(a x) Cos[c + b x] Sin[b x]"
                   "E^(a x) Cos[b x]"
                   "E^(a x) Cos[b x] Cos[c x]"
                   "E^(a x) Cos[b x] Cos[c + b x]"
                   "E^(a x) Cos[b x] Sin[c + b x]"
                   "E^(a x) Sin[b x]^n"
                   "E^(a x) Cos[b x]^n"
                   "E^x x^m Sin[x]"
                   "E^(a x) x^m Sin[b x]"
                   "E^x x^m Cos[x]"
                   "E^(a x) x^m Cos[b x]"
                   "E^(a x) x Sin[b x]"
                   "E^(a x) x Cos[b x]"
                   "E^(a x)/Sin[x]^n"
                   "E^(a x)/Cos[x]^n"
                   "x Sinh[x]"
                   "x^n Sinh[x]"
                   "x Cosh[x]"
                   "x^n Cosh[x]"
                   "Sech[x] Tanh[x]"
                   "Coth[x] Csch[x]"
                   "Sinh[x]^2"
                   "Cosh[x]^n Sinh[x]^m"
                   "1/(Cosh[x]^n Sinh[x]^m)"
                   "Tanh[x]^2"
                   "Tanh[x]^n"
                   "Sech[x]^2"
                   "Cosh[x]^2"
                   "Coth[x]^2"
                   "Coth[x]^n"
                   "Csch[x]^2"
                   "Sinh[m x] Sinh[n x]"
                   "Cosh[m x] Cosh[n x]"
                   "Cosh[n x] Sinh[m x]"
                   "ArcSinh[x/a]"
                   "x ArcSinh[x/a]"
                   "x^n ArcSinh[x]"
                   "ArcCosh[x/a]"
                   "x ArcCosh[x/a]"
                   "x^n ArcCosh[x]"
                   "ArcTanh[x/a]"
                   "ArcCoth[x/a]"
                   "x ArcTanh[x/a]"
                   "x^n ArcTanh[x]"
                   "x^(3/7) ArcTanh[x]"
                   "x ArcCoth[x/a]"
                   "x^n ArcCoth[x]"
                   "ArcSech[x]"
                   "x ArcSech[x]"
                   "x^n ArcSech[x]"
                   "ArcCsch[x]"
                   "x ArcCsch[x]"
                   "x^n ArcCsch[x]"
                   "Log[x] Log[1 + x]^2"
                   "x Log[x] Log[1 + x]^2"
                   "x^2 Log[x] Log[1 + x]^2"
                   "x^3 Log[x] Log[1 + x]^2"
                   "Log[x] Log[1 + x]^3"
                   "x Log[x] Log[1 + x]^3"
                   "x^2 Log[x] Log[1 + x]^3"
                   "x^3 Log[x] Log[1 + x]^3"
                   "Log[x] Log[1 + x]^4"
                   "x Log[x] Log[1 + x]^4"
                   "x^3 Log[x] Log[1 + x]^4"
                   "x^3 Log[x] Log[1 + b x]^2"
                   "x^3 Log[3 + x] Log[1 + b x]^2"
                   "(x Log[x] Log[1 + x])/(1 + x)"
                   "(x^2 Log[x] Log[1+x])/(1+x)"
                   "(Log[x] Log[1 + x]^2)/(1 + x)"
                   "(Log[x] Log[1+x]^2)/(1+x)^2"
                   "(x Log[x] Log[1+x]^2)/(1+x)^2"
                   "(x^3 Log[x] Log[1+x]^2)/(1+x)"
                   "1/Sqrt[x]"
                   "1/Sqrt[1 + x]"
                   "1/Sqrt[a + b x]"
                   "1/(1 + Sqrt[b + a x])"
                   "x/(1 + Sqrt[b + a x])"
                   "x^2/(1 + Sqrt[b + a x])"
                   "1/(x^(1/4) + x^(1/3))"
                   "x/(x^(1/4) + x^(1/3))"
                   "Sqrt[1 - x] Sqrt[x]"
                   "Sqrt[a x] Sqrt[1 - b x]"
                   "Sqrt[a x] Sqrt[b - a x]"
                   "1/(a+b+(e+c x+d x)^(1/3))"
                   "1/(Sqrt[1 - x] Sqrt[1 + x])"
                   "1/(Sqrt[-b+a x] Sqrt[b+a x])"
                   "a x (c + b x)^e"
                   "Sqrt[1 - x^(-2)]"
                   "Sqrt[a - x^(-2)]"
                   "Sqrt[a - b x^2]"
                   "Sqrt[1 + 3 x^2 + 3 x^4 + x^6]"
                   "Sqrt[1-4 x^3+6 x^6-4 x^9+x^12]"
                   "Sqrt[1 + x^(-2)]"
                   "Sqrt[a + b/x^2]"
                   "x/(1 + x)"
                   "Log[x]/(2 - x)"
                   "Sin[x]^7"
                   "1/(x Sqrt[-4 + x^2])"
                   "1/(x Sqrt[-4 + 2 x^2])"
                   "1/(x^2 Sqrt[-4 + 2 x^2])"
                   "Sqrt[c + b x + a x^2]"
                   "(c + b x + a x^2)^(3/2)"
                   "x Sqrt[c + b x + a x^2]"
                   "Sqrt[9 + x^2]"
                   "x Sqrt[9 + x^2]"
                   "x Sqrt[9 + 5 x^2]"
                   "1/Sqrt[b + x^2]"
                   "x Sqrt[b + a x^2]"
                   "Sqrt[-a^2 + b^2 x^2]"
                   "x Sqrt[-a^2 + b^2 x^2]"
                   "x^2 Sqrt[-a^2 + b^2 x^2]"
                   "Sqrt[-b + a x^2]/x"
                   "Sqrt[-b + a x^2]/x^2"
                   "Sqrt[x]+(c Sqrt[9+x^2])/(b x)"
                   "x^2 Sqrt[1 + x^2]"
                   "x^2 Sqrt[b + a x^2]"
                   "x^2/Sqrt[4 + 4 x^2]"
                   "1/(x^2 Sqrt[-b + a x^2])"
                   "1/(x Sqrt[-b + a x^2])"
                   "1/Sqrt[-b + a x^2]"
                   "Sqrt[a + b + c + x^2]/(d x^2)"
                   "Sqrt[a+b+c+e x^2]/(d x^2)"
                   "(-c^2+x^2+a x^2+b x^2)^(-3/2)"
                   "a (c + b x^2)^(3/2)"
                   "1/Sqrt[a - b x^2]"
                   "x/Sqrt[a - b x^2]"
                   "x^2/Sqrt[a - b x^2]"
                   "Sqrt[aa - bb x^2]"
                   "(a Sqrt[b - c x^2])/x"
                   "(a Sqrt[b - c x^2])/x^2"
                   "x^2/Sqrt[1 - x^2]"
                   "x^2 Sqrt[a - b^4 x^2]"
                   "1/(a x^2 Sqrt[c^2 - d^2 x^2])"
                   "1/(a x Sqrt[c^2 - d^2 x^2])"
                   "1/(a Sqrt[c^2 - d^2 x^2])"
                   "x/(a Sqrt[c^2 - d^2 x^2])"
                   "Sqrt[4 - c x^2]/x^2"
                   "Sqrt[4 - c x^2]/Sqrt[x]"
                   "Sqrt[c - d x^2]/x"
                   "Sqrt[c - d x^2]/x^2"
                   "Sqrt[c - d x^2]/Sqrt[x]"
                   "1/(x Sqrt[25 - 4 x^2])"
                   "1/Sqrt[25 - 4 x^2]"
                   "x/Sqrt[25 - 4 x^2]"
                   "x^2/Sqrt[25 - 4 x^2]"
                   "1/(Sqrt[x] Sqrt[25 - 4 x^2])"
                   "1/(x^(3/2) Sqrt[25 - 4 x^2])"
                   "(a - b x^2)^(3/2)"
                   "(1 - 9 x^2)^(-3/2)"
                   "Sqrt[x + Sqrt[a^2 + x^2]]/x"
                   "Sqrt[x + Sqrt[a^2 + x^2]]/x"
                   "Sin[a x + b]"
                   "Sin[x]^12"
                   "E^(b x) Sin[a x]"
                   "Log[a x]^n"
                   "BesselJ[0, x]"
                   "Sqrt[1 + x]"
                   "Sqrt[1 - a x^2]"
                   "E^(a x) Sqrt[x]"
                   "Sqrt[x] Sin[x]"
                   "Sin[x]/x"
                   "Log[Sqrt[1 + a x^2]]"
                   "(1 + a x^2)^(7/2)"
                   "Log[1 + 2 x]/(a + x)"
                   "1/(-1 + x^n)"
                   "E^(a x) x^n"
                   "x^n/(-a + x^2)"
                   "Sqrt[-a + x] Sqrt[-b + x]"
                   "Sqrt[a + x] (-b + x^2)^(3/2)"
                   "1/Sqrt[-a + x^2]"
                   "E^(a x) x^7"
                   "E^(E^x + x)"
                   "2^(2^2^x + 2^x + x) Log[2]^3"
                   "E^(E^x + x) (1 + E^x)"
                   "(-2 E^x)/x^3 + E^x/x^2"
                   "E^(5 + x) (2 + x)"
                   "1/(2 E^(I x) x)"
                   "E^x/(1 + E^(2 x))"
                   "1/(2 E^(I x) x)"
                   "E^E^(b + a x)"
                   "E^(a + b x^2)"
                   "E^(c + b x + a x^2) x"
                   "x^4/E^(a x^2)"
                   "(-r + x)^4/E^(a x^2)"
                   "E^(2 a E^(a x) + a x)"
                   "b^x c^(d x) E^(a x)"
                   "1/(1 + E^(2 x) + E^(3 x))"
                   "E^(c+a x+b x)/(f+d x+e x)"
                   "1/(E^(a + x)^2 s^2)"
                   "E^((a + b) x) x"
                   "1/(-1 + E^(a x))"
                   "x^4/(1 + E^(a x))"
                   "x/(-1 + E^x)"
                   "Gamma[a, x]"
                   "ArcSinh[x]"
                   "ArcSinh[a x]"
                   "ArcSinh[a/x]"
                   "ArcCosh[x]"
                   "ArcCosh[a x]"
                   "ArcCosh[a/x]"
                   "ArcTanh[x]"
                   "ArcTanh[a x]"
                   "ArcTanh[a/x]"
                   "ArcCoth[x]"
                   "ArcCoth[a x]"
                   "ArcCoth[a/x]"
                   "x^3 ArcSinh[x]"
                   "x^3 ArcSinh[a x]"
                   "x^3 ArcSinh[a/x]"
                   "x ArcCosh[x]"
                   "x ArcCosh[a x]"
                   "x ArcCosh[a/x]"
                   "x ArcTanh[x]"
                   "x ArcTanh[a x]"
                   "x ArcTanh[a/x]"
                   "x^4 ArcCsch[x]"
                   "Log[a+x+b x] Log[c-x+d x]^2"
                   "x^2 Log[a+b x] Log[c+d x]^2"
                   "x^2 Log[a + x]"
                   "x^2 Log[a + b x]"
                   "x^3 Log[a + b x]"
                   "x^4 Log[x]"
                   "x^4 Log[a x]"
                   "x^p Log[x]"
                   "Log[1 - x]/x"
                   "Log[a - b x]/x"
                   "Log[a - b x]/x^2"
                   "Log[b + x]/(d + x)"
                   "Log[b + a x]/(d + c x)"
                   "Log[x]/(1 - x)"
                   "Log[a x]/(a - b x)"
                   "Log[x]/(-1 + x)"
                   "Log[a x]/(-c + b x)"
                   "Log[3 + 2 x]/x"
                   "Log[3 + 2 x]/x^2"
                   "Log[x]/(3 + 2 x)"
                   "Log[a x]/(3 + 2 x)"
                   "Log[1 + x]/(1 - x)"
                   "Log[a + b x]/(a - b x)"
                   "((1 + x^2) Log[x]^2)/x"
                   "x^4 Log[x]^2"
                   "x^4 Log[2 x]^2"
                   "Log[Log[x]]"
                   "Log[Log[a x]]"
                   "Log[Sqrt[Log[a x]]]"
                   "1/(x Log[x] Log[Log[x]])"
                   "Log[1 + x^(-1)]"
                   "Log[a + b/x]"
                   "Log[a + b/x^2]"
                   "Log[a + b/Sqrt[x]]"
                   "Log[x] Log[1 + x]"
                   "Log[a x] Log[a + b x]"
                   "Log[x]^2/x^2"
                   "Log[x]^2/x^3"
                   "Sqrt[E^Sqrt[x]]"
                   "Sin[x]^(-2 + n)/Cos[x]^n"
                   "Sin[x]/(Cos[x] + Sin[x])"
                   "-(Cot[x] Csc[x])"
                   "x Csc[x]^2"
                   "Cos[x]^8 Sin[x]^5"
                   "-(Sech[x] Tanh[x])"
                   "x^5 Sinh[x]"
                   "ArcCos[x]"
                   "ArcCot[x]"
                   "ArcCsc[x]"
                   "ArcSec[x]"
                   "x^5 ArcSin[x]"
                   "x ArcCos[x]"
                   "ArcCot[x]/x^4"
                   "-x + x^3/6 - x^5/120"
                   "(EllipticE[x]-EllipticK[x])/x"
                   "1 + (4 Sin[1])/x"
                   "(a^2 + 2 x + 2 a x)/x^2"
                   "E^(1 + x) Sin[2 + x]"
                   "E^x^2/x + 2 E^x^2 x Log[x]"
                   "Log[1 + Sqrt[1 + x^2]]"
                   "Log[a + Sqrt[b + c x^2]]"
                   "Sqrt[1 - x^2] ArcSin[x]"
                   "Sqrt[a^2 - x^2] ArcSin[x/a]"
                   "Sqrt[1+E^(c+5 x)+E^(-d+10 x)]"
                   "1/(-1 + x^3)"
                   "Sin[a x]/Sqrt[x]"
                   "Sin[a x]/Sqrt[x^3]"
                   "Sin[a x]/Sqrt[a x]"
                   "Sin[a x]^2/Sqrt[a x]"
                   "Sin[Sqrt[x]]"
                   "Sin[Sqrt[a x]]"
                   "Sin[Sqrt[x]]^2"
                   "Sin[Sqrt[a x]]^2"
                   "E^(a + x)/Sqrt[x]"
                   "E^(a + b x)/Sqrt[a x]"
                   "x (Sqrt[x] + Sin[x])"
                   "a/x^5 + c/x + b x^3"
                   "3 + a x + b x^2"
                   "(2 (1 - x) + 2 x)^2"
                   "(a + a x)/(1 + x)"
                   "Sqrt[a + a x]/(b + a x)"
                   "1/Sqrt[b + a x]"
                   "1/(c + b x + a x^2)"
                   "x/(-1 + x^3)"
                   "x^2/(-1 + x^3)"
                   "1/(-1 + x^4)"
                   "Sqrt[x]/(-1 + x^4)"
                   "x/(-1 + x^4)"
                   "x^2/(-1 + x^4)"
                   "x^2/(-1 + x^4)^2"
                   "1/(-8 + x^2)"
                   "x/(-8 + x^2)"
                   "x^2/(-8 + x^2)"
                   "x^2/(-8 + x^2)^2"
                   "1/(8 + x^2)"
                   "x/(8 + x^2)"
                   "x^2/(8 + x^2)"
                   "x^2/(8 + x^2)^2"
                   "1/(2 + x^3)"
                   "1/(a + x^2)"
                   "x/((-1 + x) (2 + x))"
                   "Sqrt[x]/((-1 + x) (2 + x))"
                   "x^2/((-1 + x) (2 + x))"
                   "x/Sqrt[(-1 + x) (2 + x)]"
                   "x/((-1 + x)^2 (2 + x)^2)"
                   "x/((-1 + x)^2 (2 + x)^6)"
                   "(a+b x+c x^2+d x^3)/(-1+x^4)"
                   "(a+b x+c x^2+d x^3)/(1+x^4)"
                   "(a + b x + c x^2)/(-1 + x^3)"
                   "(a + b x + c x^2)/(1 + x^3)"
                   "1/(-b + a x^4)"
                   "x/(-b + a x^4)"
                   "Sqrt[x]/(-b + a x^4)"
                   "x^2/(-b + a x^4)"
                   "x^2/(-b + a x^4)^2"
                   "1/(a^2 + x^2)"
                   "1/(1 + x^5)"
                   "1/(-1 + x^7)"
                   "1/(1 + 5 x + x^5)"
                   "1/(x^3 (a + b x)^(1/3))"
                   "(1+2 x+x^2)/(1+(1+x)^6)"
                   "1/(a + x^2)"
                   "(a + b x)^(-3^(-1))"
                   "Log[1 + Sqrt[b + a x]]"
                   "(1 + x)/(x (x + Log[x])^(3/2))"
                   "Cosh[a x] Sinh[a x]"
                   "Log[1 + Sqrt[b + a x]]/x"
                   "1/(-2 + x^2)"
                   "1/(2 + x^2)"
                   "x^2/(-a^2 + x^2)"
                   "Log[x]/(b + a x)^2"
                   "Log[x]/Sqrt[b + a x]"
                   "x^3 Sin[x^2]"
                   "Sin[x]^p"
                   "Sqrt[1 - Cos[x]]"
                   "Sin[x]/x"
                   "E^(a x)/x"
                   "1/(b/E^(m x) + a E^(m x))"
                   "E^(a x) x"
                   "E^x x^20"
                   "(a^x x)/(1 + b x)^2"
                   "(E^(a x) x)/(1 + a x)^2"
                   "E^x x Log[x]"
                   "(a + b x)^p"
                   "x (a + b x)^p"
                   "1/(a + b x)"
                   "x/(a + b x)"
                   "x^2 (a + b x)^p"
                   "(a + b x)^(-2)"
                   "x^2/(a + b x)"
                   "1/(x (a + b x))"
                   "1/(x^2 (a + b x))"
                   "1/(x^2 (a + b x)^2)"
                   "Sqrt[a + b x] Sqrt[c + d x]"
                   "x (a + b x)^(p/2)"
                   "Sin[a + b x]"
                   "Cos[a + b x]"
                   "Tan[a + b x]"
                   "Cot[a + b x]"
                   "Csc[a + b x]"
                   "Sec[a + b x]"
                   "Sin[a + b x]^2"
                   "Sin[a + b x]^3"
                   "Cos[a + b x]^2"
                   "Cos[a + b x]^3"
                   "Sec[a + b x]^2"
                   "1/(1 + Sin[x])"
                   "1/(1 - Sin[x])"
                   "x^2 Sin[a + b x]^2"
                   "Cos[x] Cos[2 x]"
                   "x^2 Cos[a + b x]^2"
                   "Cot[x]^3"
                   "x^3 Tan[x]^4"
                   "x Tan[x]^2"
                   "Cos[3 x] Sin[2 x]"
                   "d^x x Sin[x]"
                   "d^x x^2 Sin[x]"
                   "d^x Cos[x]"
                   "d^x x Cos[x]"
                   "d^x x^2 Cos[x]"
                   "d^x x^3 Sin[x]"
                   "d^x x^3 Cos[x]"
                   "a Cos[5 + 3 x] Sin[5 + 3 x]^2"
                   "Log[x^2]/x^3"
                   "x Sin[a + x]"
                   "Sqrt[x]/(1 + x)^(7/2)"
                   "1/(x (1 + x))"
                   "1/(Sqrt[x] (-1 + 2 x))"
                   "(-a + x)^(1/3)/x"
                   "x Sinh[x]"
                   "x Cosh[x]"
                   "x^2 (x + 2 x^2)^2"
                   "x (1 + 2 x + x^2)"
                   "Tanh[2 x]"
                   "Cos[x]^2 Sin[3 + 2 x]"
                   "x ArcTan[x]"
                   "x ArcCot[x]"
                   "x Log[a + x^2]"
                   "Cos[x] Sin[a + x]"
                   "Cos[a + x] Sin[x]"
                   "Sqrt[2 + 2 Sin[x]]"
                   "Sqrt[2 - 2 Sin[x]]"
                   "Sqrt[2 + 2 Cos[x]]"
                   "Sqrt[2 - 2 Cos[x]]"
                   "1/(-Sqrt[-1 + x] + Sqrt[x])"
                   "1/(1 - Sqrt[1 + x])"
                   "x/Sqrt[36 + x^4]"
                   "1/(x^(1/3) + Sqrt[x])"
                   "Log[2 + 3 x^2]"
                   "Cot[x]^4"
                   "Sqrt[2 + x^(-4) + x^4]"
                   "x Log[x + Sqrt[1 + x^2]]"
                   "((1 + x^3) Log[x])/(2 + x^4)"
                   "1/(5 + x^3)"
                   "1/(-1 + 2 x^3)"
                   "1/(-2 + x^3)"
                   "1/(-b + a x^3)"
                   "1/(-2 + x^4)"
                   "1/(-1 + 5 x^4)"
                   "1/(7 + 3 x^4)"
                   "1/(2 + x^2 + x^4)"
                   "1/(2 - x^2 + x^4)"
                   "1/(-2 + x^6)"
                   "1/(2 + x^6)"
                   "1/(1 + x^8)"
                   "1/(1 - x^4 + x^8)"
                   "x^2 ArcSin[x]"
                   "1/Sqrt[9 + 4 x^2]"
                   "Log[2 + 3 x^2]"
                   "E^(6 x)/(1 + E^(4 x))"
                   "Csc[x] Sqrt[a^2+b^2 Sin[x]^2]"
                   "(x^2 Log[x])/(p^2 - x^2)"
                   "x^7/(1 + x^12)"
                   "1/(a + b Sin[x])"
                   "1/(a + Cos[x] + b Sin[x])"
                   "Sec[x] Sin[2 x]"
                   "1/Sqrt[(3 - x) (2 + x)]"
                   "Tanh[2^(1 - x)]/2^x"
                   "x/Sqrt[1 + x + x^2]"
                   "x^n Log[x]"
                   "Log[x]/x"
                   "3^Sqrt[1 + 2 x]"
                   "(6 - x)/((-3 + x) (5 + 2 x))"
                   "1/(5 + 3 Cos[x])"
                   "E^Sin[x^3] x^2 Cos[x^3]"
                   "1/(x^2 Sqrt[-1 + x^2])"
                   "x/Sqrt[5 + 2 x + x^2]"
                   "x Cos[3 x]"
                   "x^3/E^(2 x)"
                   "1/(1 + Tan[x]^4)"
                   "Sec[2 a x]^2"
                   "Sec[x] (Cos[x] + Sin[x])"
                   "Sec[x] Tan[x]"
                   "(1 + Tan[x])^2"
                   "E^x Cos[E^x]"
                   "E^(3 Cos[2 x]) Sin[2 x]"
                   "1/(1 + Cos[x])"
                   "(Sec[2 x] + Tan[2 x])^2"
                   "(-1 + Sec[4 x])^2"
                   "(Sec[x] Tan[x])/(a + b Sec[x])"
                   "1/(-Cot[2 x] + Csc[2 x])"
                   "1/Sqrt[1 - x^2]"
                   "1/Sqrt[4 - x^2]"
                   "1/(1 + x^2)"
                   "1/(9 + x^2)"
                   "1/(x Sqrt[-1 + x^2])"
                   "1/Sqrt[25 - 16 x^2]"
                   "1/(9 + 4 x^2)"
                   "1/(x Sqrt[9 + 4 x^2])"
                   "1/(x Sqrt[-9 + 4 x^2])"
                   "x^2/Sqrt[1 - x^6]"
                   "x/(3 + x^4)"
                   "1/(x Sqrt[-1 + x^4])"
                   "1/Sqrt[4 - (2 + x)^2]"
                   "1/(E^(-x) + E^x)"
                   "(3 x-4 x^2+3 x^3)/(1+x^2)"
                   "(Sec[x] Tan[x])/(9+4 Sec[x]^2)"
                   "(3 + x)/Sqrt[1 - x^2]"
                   "(-7 + 2 x)/(9 + x^2)"
                   "1/(30 + 10 x + x^2)"
                   "Sqrt[20 + 8 x - x^2]"
                   "1/Sqrt[20 + 8 x - x^2]"
                   "1/(5 + 2 x + 2 x^2)"
                   "(1 + x)/(8 - 4 x + x^2)"
                   "1/Sqrt[28 - 12 x - x^2]"
                   "(3 + x)/Sqrt[5 - 4 x - x^2]"
                   "(3 + 2 x)/(8 - 12 x + 9 x^2)"
                   "(2 + x)/Sqrt[4 x - x^2]"
                   "1/(-1 + x^2)"
                   "1/(9 - x^2)"
                   "1/(1 - x^2)"
                   "1/Sqrt[1 + x^2]"
                   "1/(-4 + x^2)"
                   "1/Sqrt[-1 + x^2]"
                   "1/Sqrt[9 + 4 x^2]"
                   "1/Sqrt[-25 + 9 x^2]"
                   "1/(-16 + 9 x^2)"
                   "1/(25 - 16 x^2)"
                   "1/(8 + 6 x + x^2)"
                   "1/(4 x - x^2)"
                   "1/Sqrt[4 x + x^2]"
                   "(2 + x)/Sqrt[9 + x^2]"
                   "(-3 + 2 x)/(-11 + 4 x^2)"
                   "(2 + x)/Sqrt[-3 + 2 x + x^2]"
                   "(2 - x)/(-3 + 4 x + 4 x^2)"
                   "Sqrt[25 - x^2]"
                   "Sqrt[3 - 4 x^2]"
                   "Sqrt[-36 + x^2]"
                   "Sqrt[5 + 3 x^2]"
                   "Sqrt[3 - 2 x - x^3]"
                   "Sqrt[3 - 2 x - x^2]"
                   "Sqrt[5 - 4 x + 4 x^2]"
                   "x Sin[x]"
                   "x Sqrt[1 + x]"
                   "ArcSin[x]"
                   "Sec[x]^3"
                   "x^2 Sin[x]"
                   "E^(2 x) x^3"
                   "(1 + x^2)^(-5/2)"
                   "(9 + x^2)^(3/2)"
                   "Cos[x]^2"
                   "Cos[3 x]^2"
                   "Sin[x]^3"
                   "Cos[x]^5"
                   "Cos[x]^3 Sin[x]^2"
                   "Cos[2 x]^4 Sin[2 x]^3"
                   "Cos[x/3]^3"
                   "Sin[x]^4"
                   "Cos[x]^2 Sin[x]^2"
                   "Tan[x]^4"
                   "Tan[x]^5"
                   "Sec[2 x]^4"
                   "1/(x^2 Sqrt[4 + x^2])"
                   "x^2/Sqrt[-4 + x^2]"
                   "Sqrt[9 - 4 x^2]/x"
                   "1/(x Sqrt[9 + 4 x^2])"
                   "(16 - 9 x^2)^(3/2)/x^6"
                   "x^2/Sqrt[2 x - x^2]"
                   "(27 - 24 x + 4 x^2)^(-3/2)"
                   "1/(-4 + x^2)"
                   "1/(-4 + x^2)"
                   "(1 + x)/(-6 x + x^2 + x^3)"
                   "(5 + 3 x)/(1 - x - x^2 + x^3)"
                   "(-1-x-x^3+x^4)/(-x^2+x^3)"
                   "(2+x+x^2+x^3)/(2+3 x^2+x^4)"
                   "x^2/(a^4 - x^4)"
                   "(3 + 2 x^2)/(1 + x^2)^2"
                   "1/(Sqrt[1 - x] x)"
                   "1/((-2 + x) Sqrt[2 + x])"
                   "1/(-x^(1/4) + Sqrt[x])"
                   "1/(x Sqrt[2 + x + x^2])"
                   "x/(5 - 4 x - x^2)^(3/2)"
                   "1/(1 - Cos[x] + Sin[x])"
                   "Sinh[x/2]"
                   "E^x Cosh[x]"
                   "x^2 (4 - x^2)^2"
                   "(2 - x)^(-3)"
                   "x/(4 + x^2)^3"
                   "(1 - x^3)^2"
                   "x (1 - x^3)^2"
                   "x^2 (1 - x^3)^2"
                   "(-1 + 2 x) (-x + x^2)^4"
                   "(1 + x)/Sqrt[-4 + 2 x + x^2]"
                   "(a + b x)^(-3^(-1))"
                   "(1 + Sqrt[x])^2/Sqrt[x]"
                   "(3 - 5 x) Sqrt[x]"
                   "((-2 + x) (1 + x))/Sqrt[x]"
                   "1/(-1 + x)"
                   "1/(1 + 3 x)"
                   "(3 x)/(2 + x^2)"
                   "x^2/(1 - x^3)"
                   "(-1 + x)/(1 + x)"
                   "(2 + 2 x + x^2)/(2 + x)"
                   "(1 + x)/(2 + 2 x + x^2)"
                   "(-1+2 x)^(-1)-(1+2 x)^(-1)"
                   "E^x^(-2)/x^3"
                   "E^(2 - x^2) x"
                   "E^x^3 x^2"
                   "(1 + E^x)^2"
                   "E^x - x^E"
                   "E^x (1 + E^x)^2"
                   "E^(2 x)/(3 + E^(2 x))"
                   "(E^(-x) + E^x)^2"
                   "(-1 + E^x)/(1 + E^x)"
                   "(-1 + E^(2 x))/(3 + E^(2 x))"
                   "1/((1 - Sqrt[x]) Sqrt[x])"
                   "1/(x^(1/3) + x)"
                   "Sin[2 x]"
                   "Cos[x/2]"
                   "Sec[3 x] Tan[3 x]"
                   "Csc[2 x]^2"
                   "x Sec[x^2]^2"
                   "Tan[x]^2"
                   "Tan[x/2]"
                   "Csc[3 x]"
                   "b Sec[a x] Tan[a x]"
                   "(Cos[x] - Sin[x])^2"
                   "Cos[x] Sin[x]^3"
                   "Cos[x]^4 Sin[x]"
                   "Sec[x]^2 Tan[x]^5"
                   "Cot[3 x]^4 Csc[3 x]^2"
                   "1/(1 - Sin[x/2])"
                   "1/(1 + Cos[3 x])"
                   "1/(1 + Sec[a x])"
                   "Sec[x/a]^2 Tan[x/a]"
                   "Csc[3 x] Sec[3 x]"
                   "Sec[x]^4 Tan[x]"
                   "E^Tan[2 x] Sec[2 x]^2"
                   "E^(2 Sin[3 x]) Cos[3 x]"
                   "1/Sqrt[5 - x^2]"
                   "1/(5 + x^2)"
                   "1/(x Sqrt[-5 + x^2])"
                   "E^x/Sqrt[1 - E^(2 x)]"
                   "E^(2 x)/(1 + E^(4 x))"
                   "(-3 + 2 x)/(13 + 6 x + x^2)"
                   "1/Sqrt[4 - 9 x^2]"
                   "1/(4 + 9 x^2)"
                   "Sin[8 x]/(9 + Sin[4 x]^4)"
                   "Sec[x]^2/Sqrt[1 - 4 Tan[x]^2]"
                   "1/(x Sqrt[4 - 9 Log[x]^2])"
                   "(-x^2 + 2 x^4)/(1 + 2 x^2)"
                   "Cos[2 x]/(8 + Sin[2 x]^2)"
                   "(-1 + x)/(3 - 4 x + 3 x^2)"
                   "x/Sqrt[27 + 6 x - x^2]"
                   "(5-4 x)/Sqrt[-8+12 x-4 x^2]"
                   "1/(-4 + x^2)"
                   "1/(-9 + 4 x^2)"
                   "1/(9 - x^2)"
                   "1/(25 - 9 x^2)"
                   "1/Sqrt[4 + x^2]"
                   "1/Sqrt[-25 + 4 x^2]"
                   "Sqrt[16 - 9 x^2]"
                   "Sqrt[-16 + x^2]"
                   "Sqrt[9 + 4 x^2]"
                   "Sqrt[-3 - 2 x + x^2]"
                   "Sqrt[12 + 4 x - x^2]"
                   "4 x + x^2"
                   "Sqrt[4 x + x^2]"
                   "Sqrt[-8 x + x^2]"
                   "Sqrt[6 x - x^2]"
                   "x Cos[x]"
                   "x Sec[3 x]^2"
                   "ArcCos[2 x]"
                   "ArcTan[x]"
                   "Sqrt[1 - x] x^2"
                   "(E^x x)/(1 + x)^2"
                   "x ArcTan[x]"
                   "x^2/E^(3 x)"
                   "x^3 Sin[x]"
                   "x^2/Sqrt[1 + x]"
                   "x ArcSin[x^2]"
                   "Sin[x] Sin[3 x]"
                   "Sin[Log[x]]"
                   "(1 - x^2)^(-3)"
                   "(4 + x^2)^(-3/2)"
                   "(4 - x^2)^(3/2)"
                   "(-16 + x^2)^(-3)"
                   "(-1 + x^2)^(5/2)"
                   "Sin[x]^4"
                   "Cos[x]^5"
                   "Cos[x]^2 Sin[x]^3"
                   "Cos[x]^5 Sin[x]^4"
                   "E^(2 x) Cos[3 x]"
                   "Cos[2 x] Sin[3 x]"
                   "E^(3 x) x^2 Sin[x]"
                   "Cos[a x^2]"
                   "1/(Cos[x] + Sin[x])"
                   "x/(Cos[x] + Sin[x])"
                   "x/(Cos[x] + Sin[x])^2"
                   "Sin[3 + x]"
                   "Sin[3 + 2 x]"
                   "Sin[3 + 2 x]^2"
                   "Cos[3 + x] Sin[1 + x]"
                   "Cos[3 + 2 x] Sin[1 + 2 x]"
                   "x/(1 + Sin[x])"
                   "x^2/(1 + Sin[x])"
                   "x/Sqrt[1 + Sin[x]]"
                   "x/(1 + Sin[x])^2"
                   "x/(1 + Cos[x])"
                   "x^2/(1 + Cos[x])"
                   "x/(1 + Cos[x])^2"
                   "Cos[x]^4"
                   "Cos[b + a x]^4"
                   "Sin[a + b x + c x^2]"
                   "Sin[a x^2]"
                   "Tan[b + a x]"
                   "a Cot[b x]"
                   "Sec[c+(a+b) x] Sin[c+a x+b x]"
                   "Cos[x] Sin[x]"
                   "Cos[a x] Sin[b x]"
                   "a Csc[b - c x]"
                   "Sec[b x + c x]"
                   "Sec[a x - b x]^2"
                   "Csc[x] Sin[6 x]"
                   "Sin[(a-b) x]/2+Sin[(a+b) x]/2"
                   "Sin[x]/(a + x)"
                   "1/(1 + Tan[x])"
                   "x/(1 + Tan[x])"
                   "1/(1 + Tan[a x])"
                   "1/(b + Tan[a x])"
                   "x/(b + Tan[a x])"
                   "Tan[x]/(1 + Tan[x]^2)"
                   "Tan[a x]/(b + Tan[a x]^2)"
                   "Tan[a x]^2/(b + Tan[a x]^2)"
                   "Sin[b + a x]^6"
                   "Cos[c x]^4"
                   "Sin[x]^6"
                   "Sin[a x]^6"
                   "Sin[b + a x]^6"
                   "6 a Cos[a x] Sin[a x]^5"
                   "Sin[a x]^5"
                   "Sin[b + a x]^5"
                   "Cos[x]^7"
                   "Cos[a x]^7"
                   "Cos[b + a x]^7"
                   "Tan[x]^6"
                   "Tan[a x]^6"
                   "Tan[b + a x]^6"
                   "a Sec[x]^4"
                   "a Sec[a x]^4"
                   "a Sec[b + a x]^4"
                   "Sec[x]^5"
                   "x Sec[x]^5"
                   "b Csc[a x]^3"
                   "a Csc[b x]^6"
                   "a Csc[a + b x]^6"
                   "1/(1 + Log[x])"
                   "x/(1 + Log[x])"
                   "x^2/(1 + Log[x])"
                   "x^2/(a + Log[x])"
                   "x^2/(a + Log[b x])"
                   "x^2/(a + Log[b x^2])"
                   "Sqrt[Sin[x]]"
                   "Sqrt[Sin[a x]]"
                   "Log[Sec[x] + Tan[x]]"
                   "Sqrt[E^x]/2+Sqrt[3] d x^(2/3)"
                   "Sqrt[1 + x] Log[x]"
                   "Sqrt[1 + E^(5 x) + E^(10 x)]"
                   "Sqrt[x]/Sqrt[a^3 - x^3]"
                   "Sinh[x]/(I + a + x)"
                   "x + Sin[x ((I Pi)/2 + x)]"
                   "ArcSin[x^a]"
                   "ArcSin[x^E]"
                   "1/(x^(-2 a) + x^a)"
                   "x (E^x + Tanh[2 x])"
                   "Sqrt[x]/Sqrt[a^3 - x^3]"
                   "Sinh[x]/(I + a + x)"
                   "ArcSin[x^a]"
                   "ArcSin[x^E]"
                   "1/(x^(-2 a) + x^a)"
                   "x (E^x + Tanh[2 x])"
                   "x Log[E^(c Sin[2])]^Sin[1]"
                   "x^2/(a + Sqrt[a + b] + x)"
                   "-(E^(x^2/2) (Pi + x))"
                   "Tanh[1/2 + Log[x]]"
                   "Tanh[a + Log[x]]"
                   "2^(x + x^2)"
                   "x - Sin[3^(2/5) + x]"
                   "x Coth[Sqrt[2] - x]"
                   "Sqrt[E^x] + Sqrt[1 + x]"
                   "Sqrt[1 + E^x] + Sqrt[1 + x]"
                   "Sqrt[-x] + Sqrt[Sin[x]]"
                   "x + 1/Sqrt[x^2]"
                   "(Pi + ArcCos[x])^2/x"
                   "x + 1/Sqrt[x^2]"
                   "1/(Sqrt[2^x] x)"
                   "Sqrt[E] Sqrt[x] Sin[x]"
                   "2^Sqrt[-x]"
                   "(Sqrt[2] + Sqrt[x])^b"
                   "(a + Sqrt[x])^b"
                   "16 x^3+x/((2 x^3-x^4) (x+x^4))"
                   "Tan[x]^3"
                   "Cot[x]^2"
                   "Cot[x]^3"
                   "Cot[x]^4"
                   "Cot[x]^5"
                   "Cot[x]^6"
                   "Sin[x]^2"
                   "Cos[x]^3"
                   "Csc[x]^3"
                   "Sin[a x] Sin[b x]"
                   "Cos[a x] Cos[b x]"
                   "Cos[b x] Sin[a x]"
                   "(2 E^x)/(1 + E^(2 x))"
                   "(1+(a-b)^(10/3))/(a-b)^(5/3)"
                   "E^(1 - t) (1 - t) Sin[t]"
                   "Csch[Sqrt[x]]^2/Sqrt[x]"
                   "(3 t)/(3 + t^2)^(1/3)")))
      (lambda ()
        (vector-ref examples (random 1370)))))
  
  
  (define (answer-page bindings)
    (let* ((function (extract-binding/single 'function bindings))
           (form (extract-binding/single 'form bindings))
           (a (synchronizeeval `(ToExpression ,function)))
           (b (synchronizeeval `(Integrate ,a x))))
      (cond ((string=? form "StandardForm")
             (gif (synchronizeeval `(ExportString (HoldForm (Equal (Integrate ,a x) ,b)) "GIF"))))
            ((string=? form "TraditionalForm")
             (gif (synchronizeeval `(ExportString (TraditionalForm (HoldForm (Equal (Integrate ,a x) ,b))) "GIF"))))
            ((string=? form "InputForm")
             (text (string-append "Integrate[" function ", x] == "
                                  (synchronizeeval `(ExportString (InputForm ,b) "Text")))))
            ((string=? form "OutputForm")
             (text (synchronizeeval `(ExportString (OutputForm (HoldForm (Equal (Integrate ,a x) ,b))) "Text")))))))
  
  (define (gif s)
    (send/suspend/dispatch
     (lambda (embed/url)
       `(html (head (title "The integrator--Integrals from Mathematica and Scheme"))
              (body (img ((src ,(embed/url
                                 (lambda _
                                   (make-response/full 200 "OK"
                                                       (current-seconds)
                                                       #"image/gif"
                                                       ()
                                                       (list (string->bytes/latin-1 s)))))))))))))
  
  (define (text s)
    (make-response/full 200 "OK" (current-seconds) #"text/plain" () (list s)))
  
  (define (get-bindings)
    (request-bindings
     (send/suspend
      (lambda (k-url)
        `(html (head (title "The integrator--Integrals from Mathematica and Scheme"))
               (body (form ((action ,k-url) (method "post"))
                           (p "Enter any function: ")
                           (p (img ((src "/integral.gif")))
                              (input ([type "text"] [name "function"] [value ,(random-example)]))
                              (img ((src "/dx.gif"))))
                           (p (input ([type "radio"] [name "form"] [value "StandardForm"] [checked "checked"]))
                              "StandardForm"
                              (input ([type "radio"] [name "form"] [value "TraditionalForm"]))
                              "TraditionalForm"
                              (input ([type "radio"] [name "form"] [value "InputForm"]))
                              "InputForm"
                              (input ([type "radio"] [name "form"] [value "OutputForm"]))
                              "OutputForm")
                           (p (input ([type "submit"] [value "Compute"]))))))))))
  
  (define (start initial-request)
    (answer-page (get-bindings))))