(module pool mzscheme
  
  (require (lib "class.ss"))
  
  (provide pool%)
  
  (define pool%
    (class object%
      (init-field pool)
      (public call-with-pool)
      
      (define i (vector-length pool))
      (define sema1 (make-semaphore i))
      (define sema2 (make-semaphore 1))
      
      (define (put! v)
        (semaphore-wait sema2)
        (vector-set! pool i v)
        (set! i (add1 i))
        (semaphore-post sema2))
      (define (get!)
        (semaphore-wait sema2)
        (set! i (sub1 i))
        (begin0 (vector-ref pool i)
                (semaphore-post sema2)))
      (define (call-with-pool fun arg)
        (semaphore-wait sema1)
        (let ((p (get!)))
          (begin0 (fun arg p)
                  (put! p)
                  (semaphore-post sema1))))
      
      (super-new))))
