
;; This table omits anything that the expander implements itself,
;; since the expander will export its own variant instead of the
;; `kernel-table` variant.

(define-primitive-table kernel-table
  [* (known-procedure/folding -1)]
  [+ (known-procedure/folding -1)]
  [- (known-procedure/folding -2)]
  [/ (known-procedure/folding -2)]
  [< (known-procedure/folding -2)]
  [<= (known-procedure/folding -2)]
  [= (known-procedure/folding -2)]
  [> (known-procedure/folding -2)]
  [>= (known-procedure/folding -2)]
  [abort-current-continuation (known-procedure/no-return -2)]
  [abs (known-procedure/folding 2)]
  [absolute-path? (known-procedure/no-prompt 2)]
  [acos (known-procedure/folding 2)]
  [add1 (known-procedure/folding 2)]
  [alarm-evt (known-procedure/no-prompt 6)]
  [always-evt (known-authentic)]
  [andmap (known-procedure -4)]
  [angle (known-procedure/folding 2)]
  [append (known-procedure/no-prompt -1)]
  [apply (known-procedure -4)]
  [arithmetic-shift (known-procedure/folding/limited 4 'expt)]
  [arity-at-least (known-constant)]
  [arity-at-least-value (known-procedure 2)]
  [arity-at-least? (known-procedure/pure/folding 2)]
  [asin (known-procedure/folding 2)]
  [assert-unreachable (known-procedure/no-return 1)]
  [assoc (known-procedure/single-valued 12)]
  [assq (known-procedure/no-prompt 4)]
  [assv (known-procedure/no-prompt 4)]
  [atan (known-procedure/folding 6)]
  [banner (known-procedure/pure 1)]
  [black-box (known-procedure/no-prompt 2)]
  [bitwise-and (known-procedure/folding -1)]
  [bitwise-bit-field (known-procedure/folding 8)]
  [bitwise-bit-set? (known-procedure/folding 4)]
  [bitwise-first-bit-set (known-procedure/folding 2)]
  [bitwise-ior (known-procedure/folding -1)]
  [bitwise-not (known-procedure/folding 2)]
  [bitwise-xor (known-procedure/folding -1)]
  [boolean? (known-procedure/pure/folding 2)]
  [box (known-procedure/allocates 2)]
  [box-cas! (known-procedure/has-unsafe 8 'unsafe-box*-cas!)]
  [box-immutable (known-procedure/allocates 2)]
  [box? (known-procedure/pure/folding 2)]
  [break-enabled (known-procedure/no-prompt 3)]
  [break-thread (known-procedure/no-prompt 6)]
  [build-path (known-procedure/no-prompt -2)]
  [build-path/convention-type (known-procedure/no-prompt -4)]
  [byte-pregexp (known-procedure/no-prompt 6)]
  [byte-pregexp? (known-procedure/pure/folding 2)]
  [byte-ready? (known-procedure/single-valued 3)]
  [byte-regexp (known-procedure/no-prompt 6)]
  [byte-regexp? (known-procedure/pure/folding 2)]
  [byte? (known-procedure/pure/folding 2)]
  [bytes (known-procedure/no-prompt -1)]
  [bytes->immutable-bytes (known-procedure/no-prompt 2)]
  [bytes->list (known-procedure/no-prompt 2)]
  [bytes->path (known-procedure/no-prompt 6)]
  [bytes->path-element (known-procedure/no-prompt 14)]
  [bytes->string/latin-1 (known-procedure/no-prompt 30)]
  [bytes->string/locale (known-procedure/no-prompt 30)]
  [bytes->string/utf-8 (known-procedure/no-prompt 30)]
  [bytes-append (known-procedure/no-prompt -1)]
  [bytes-close-converter (known-procedure/no-prompt 2)]
  [bytes-convert (known-procedure/no-prompt/multi 252)]
  [bytes-convert-end (known-procedure/no-prompt/multi 30)]
  [bytes-converter? (known-procedure/pure/folding 2)]
  [bytes-copy (known-procedure/no-prompt 2)]
  [bytes-copy! (known-procedure/has-unsafe 56 'unsafe-bytes-copy!)]
  [bytes-fill! (known-procedure/no-prompt 4)]
  [bytes-length (known-procedure/has-unsafe 2 'unsafe-bytes-length)]
  [bytes-open-converter (known-procedure/no-prompt 4)]
  [bytes-ref (known-procedure/has-unsafe 4 'unsafe-bytes-ref)]
  [bytes-set! (known-procedure/has-unsafe 8 'unsafe-bytes-set!)]
  [bytes-utf-8-index (known-procedure/no-prompt 60)]
  [bytes-utf-8-length (known-procedure/no-prompt 30)]
  [bytes-utf-8-ref (known-procedure/no-prompt 60)]
  [bytes<? (known-procedure/no-prompt -2)]
  [bytes=? (known-procedure/no-prompt -2)]
  [bytes>? (known-procedure/no-prompt -2)]
  [bytes? (known-procedure/pure/folding 2)]
  [caaaar (known-procedure/no-prompt 2)]
  [caaadr (known-procedure/no-prompt 2)]
  [caaar (known-procedure/no-prompt 2)]
  [caadar (known-procedure/no-prompt 2)]
  [caaddr (known-procedure/no-prompt 2)]
  [caadr (known-procedure/no-prompt 2)]
  [caar (known-procedure/no-prompt 2)]
  [cadaar (known-procedure/no-prompt 2)]
  [cadadr (known-procedure/no-prompt 2)]
  [cadar (known-procedure/no-prompt 2)]
  [caddar (known-procedure/no-prompt 2)]
  [cadddr (known-procedure/no-prompt 2)]
  [caddr (known-procedure/no-prompt 2)]
  [cadr (known-procedure/no-prompt 2)]
  [call-in-continuation (known-procedure 4)]
  [call-in-nested-thread (known-procedure 6)]
  [call-with-composable-continuation (known-procedure 6)]
  [call-with-continuation-barrier (known-procedure 2)]
  [call-with-continuation-prompt (known-procedure -2)]
  [call-with-current-continuation (known-procedure 6)]
  [call-with-escape-continuation (known-procedure 2)]
  [call-with-immediate-continuation-mark (known-procedure 12)]
  [call-with-input-file (known-procedure/no-prompt/multi 12)]
  [call-with-output-file (known-procedure/no-prompt/multi 28)]
  [call-with-semaphore (known-procedure -4)]
  [call-with-semaphore/enable-break (known-procedure -4)]
  [call-with-values (known-procedure 4)]
  [car (known-procedure/no-prompt 2)]
  [cdaaar (known-procedure/no-prompt 2)]
  [cdaadr (known-procedure/no-prompt 2)]
  [cdaar (known-procedure/no-prompt 2)]
  [cdadar (known-procedure/no-prompt 2)]
  [cdaddr (known-procedure/no-prompt 2)]
  [cdadr (known-procedure/no-prompt 2)]
  [cdar (known-procedure/no-prompt 2)]
  [cddaar (known-procedure/no-prompt 2)]
  [cddadr (known-procedure/no-prompt 2)]
  [cddar (known-procedure/no-prompt 2)]
  [cdddar (known-procedure/no-prompt 2)]
  [cddddr (known-procedure/no-prompt 2)]
  [cdddr (known-procedure/no-prompt 2)]
  [cddr (known-procedure/no-prompt 2)]
  [cdr (known-procedure/no-prompt 2)]
  [ceiling (known-procedure/folding 2)]
  [channel-put-evt (known-procedure/no-prompt 4)]
  [channel-put-evt? (known-procedure/pure/folding 2)]
  [channel? (known-procedure/pure/folding 2)]
  [chaperone-box (known-procedure/single-valued -8)]
  [chaperone-channel (known-procedure/single-valued -8)]
  [chaperone-continuation-mark-key (known-procedure/single-valued -8)]
  [chaperone-evt (known-procedure/single-valued -4)]
  [chaperone-hash (known-procedure/single-valued -32)]
  [chaperone-of? (known-procedure/single-valued 4)]
  [chaperone-procedure (known-procedure/no-prompt -4)]
  [chaperone-procedure* (known-procedure/no-prompt -4)]
  [chaperone-prompt-tag (known-procedure/single-valued -8)]
  [chaperone-struct (known-procedure/single-valued -2)]
  [chaperone-struct-type (known-procedure/single-valued -16)]
  [chaperone-vector (known-procedure/single-valued -8)]
  [chaperone-vector* (known-procedure/single-valued -8)]
  [chaperone? (known-procedure/pure/folding 2)]
  [char->integer (known-procedure/folding 2)]
  [char-alphabetic? (known-procedure/folding 2)]
  [char-blank? (known-procedure/folding 2)]
  [char-ci<=? (known-procedure/folding -2)]
  [char-ci<? (known-procedure/folding -2)]
  [char-ci=? (known-procedure/folding -2)]
  [char-ci>=? (known-procedure/folding -2)]
  [char-ci>? (known-procedure/folding -2)]
  [char-downcase (known-procedure/folding 2)]
  [char-extended-pictographic? (known-procedure/folding 2)]
  [char-foldcase (known-procedure/folding 2)]
  [char-general-category (known-procedure/folding 2)]
  [char-grapheme-step (known-procedure/no-prompt/multi 4)]
  [char-grapheme-break-property (known-procedure/folding 2)]
  [char-graphic? (known-procedure/folding 2)]
  [char-iso-control? (known-procedure/folding 2)]
  [char-lower-case? (known-procedure/folding 2)]
  [char-numeric? (known-procedure/folding 2)]
  [char-punctuation? (known-procedure/folding 2)]
  [char-ready? (known-procedure/folding 3)]
  [char-symbolic? (known-procedure/folding 2)]
  [char-title-case? (known-procedure/folding 2)]
  [char-titlecase (known-procedure/folding 2)]
  [char-upcase (known-procedure/folding 2)]
  [char-upper-case? (known-procedure/folding 2)]
  [char-utf-8-length (known-procedure/folding 2)]
  [char-whitespace? (known-procedure/folding 2)]
  [char<=? (known-procedure/folding -2)]
  [char<? (known-procedure/folding -2)]
  [char=? (known-procedure/folding -2)]
  [char>=? (known-procedure/folding -2)]
  [char>? (known-procedure/folding -2)]
  [char? (known-procedure/pure/folding 2)]
  [checked-procedure-check-and-extract (known-procedure 32)]
  [choice-evt (known-procedure/no-prompt -1)]
  [cleanse-path (known-procedure/no-prompt 2)]
  [close-input-port (known-procedure/no-prompt 2)]
  [close-output-port (known-procedure/no-prompt 2)]
  [collect-garbage (known-procedure/no-prompt 3)]
  [compile-allow-set!-undefined (known-constant)]
  [compile-context-preservation-enabled (known-constant)]
  [compile-enforce-module-constants (known-constant)]
  [compile-target-machine? (known-procedure/no-prompt 2)]
  [complete-path? (known-procedure/no-prompt 2)]
  [complex? (known-procedure/pure/folding 2)]
  [cons (known-procedure/allocates 4)]
  [continuation-mark-key? (known-procedure/pure/folding 2)]
  [continuation-mark-set->context (known-procedure/no-prompt 6)]
  [continuation-mark-set->iterator (known-procedure/no-prompt 28)]
  [continuation-mark-set->list (known-procedure/no-prompt 12)]
  [continuation-mark-set->list* (known-procedure/no-prompt 28)]
  [continuation-mark-set-first (known-procedure/no-prompt 28)]
  [continuation-mark-set? (known-procedure/pure/folding 2)]
  [continuation-marks (known-procedure/single-valued 6)]
  [continuation-prompt-available? (known-procedure/single-valued 6)]
  [continuation-prompt-tag? (known-procedure/pure/folding 2)]
  [continuation? (known-procedure/pure/folding 2)]
  [copy-file (known-procedure/no-prompt 12)]
  [cos (known-procedure/folding 2)]
  [current-code-inspector (known-procedure/parameter 3)]
  [current-command-line-arguments (known-procedure/parameter 3)]
  [current-compile-target-machine (known-procedure/parameter 3)]
  [current-compile-realm (known-procedure/parameter 3)]
  [current-continuation-marks (known-procedure/single-valued 3)]
  [current-custodian (known-procedure/parameter 3)]
  [current-directory (known-procedure/parameter 3)]
  [current-directory-for-user (known-procedure/parameter 3)]
  [current-drive (known-procedure/no-prompt 1)]
  [current-environment-variables (known-procedure/parameter 3)]
  [current-error-message-adjuster (known-procedure/parameter 3)]
  [current-error-port (known-procedure/parameter 3)]
  [current-evt-pseudo-random-generator (known-procedure/parameter 3)]
  [current-force-delete-permissions (known-procedure/parameter 3)]
  [current-gc-milliseconds (known-procedure/no-prompt 1)]
  [current-get-interaction-evt (known-procedure/parameter 3)]
  [current-get-interaction-input-port (known-procedure/parameter 3)]
  [current-inexact-milliseconds (known-procedure/no-prompt 1)]
  [current-inexact-monotonic-milliseconds (known-procedure/no-prompt 1)]
  [current-input-port (known-procedure/parameter 3)]
  [current-inspector (known-procedure/parameter 3)]
  [current-load-extension (known-procedure/parameter 3)]
  [current-load-relative-directory (known-procedure/parameter 3)]
  [current-locale (known-procedure/parameter 3)]
  [current-logger (known-procedure/parameter 3)]
  [current-memory-use (known-procedure/no-prompt 3)]
  [current-milliseconds (known-procedure/no-prompt 1)]
  [current-output-port (known-procedure/parameter 3)]
  [current-plumber (known-procedure/parameter 3)]
  [current-preserved-thread-cell-values (known-procedure/no-prompt 3)]
  [current-print (known-procedure/parameter 3)]
  [current-process-milliseconds (known-procedure/no-prompt 3)]
  [current-prompt-read (known-procedure/parameter 3)]
  [current-pseudo-random-generator (known-procedure/parameter 3)]
  [current-read-interaction (known-procedure/parameter 3)]
  [current-seconds (known-procedure/no-prompt 1)]
  [current-security-guard (known-procedure/parameter 3)]
  [current-subprocess-custodian-mode (known-procedure/parameter 3)]
  [current-subprocess-keep-file-descriptors (known-procedure/parameter 3)]
  [current-thread (known-procedure/succeeds 1)]
  [current-thread-group (known-procedure/parameter 3)]
  [current-thread-initial-stack-size (known-procedure/parameter 3)]
  [current-write-relative-directory (known-procedure/parameter 3)]
  [custodian-box-value (known-procedure/no-prompt 2)]
  [custodian-box? (known-procedure/pure/folding 2)]
  [custodian-limit-memory (known-procedure/no-prompt 12)]
  [custodian-managed-list (known-procedure/no-prompt 4)]
  [custodian-memory-accounting-available? (known-procedure/no-prompt 1)]
  [custodian-require-memory (known-procedure/no-prompt 8)]
  [custodian-shut-down? (known-procedure/no-prompt 2)]
  [custodian-shutdown-all (known-procedure/single-valued 2)]
  [custodian? (known-procedure/pure/folding 2)]
  [custom-print-quotable-accessor (known-procedure/no-prompt 6)]
  [custom-print-quotable? (known-procedure/no-prompt 2)]
  [custom-write-accessor (known-procedure/no-prompt 6)]
  [custom-write? (known-procedure/pure/folding 2)]
  [date (known-constant)]
  [date* (known-constant)]
  [date*-nanosecond (known-procedure/single-valued 2)]
  [date*-time-zone-name (known-procedure/single-valued 2)]
  [date*? (known-procedure/pure/folding 2)]
  [date-day (known-procedure/single-valued 2)]
  [date-dst? (known-procedure/single-valued 2)]
  [date-hour (known-procedure/single-valued 2)]
  [date-minute (known-procedure/single-valued 2)]
  [date-month (known-procedure/single-valued 2)]
  [date-second (known-procedure/single-valued 2)]
  [date-time-zone-offset (known-procedure/single-valued 2)]
  [date-week-day (known-procedure/single-valued 2)]
  [date-year (known-procedure/single-valued 2)]
  [date-year-day (known-procedure/single-valued 2)]
  [date? (known-procedure/pure/folding 2)]
  [datum->syntax (known-procedure/no-prompt 60)]
  [datum-intern-literal (known-procedure/no-prompt 2)]
  [default-continuation-prompt-tag (known-procedure/pure 1)]
  [default-global-port-print-handler (known-procedure/single-valued 12)]
  [delete-directory (known-procedure/no-prompt 2)]
  [delete-file (known-procedure/no-prompt 2)]
  [denominator (known-procedure/folding 2)]
  [directory-exists? (known-procedure/no-prompt 2)]
  [directory-list (known-procedure/no-prompt 3)]
  [display (known-procedure/single-valued 6)]
  [dump-memory-stats (known-procedure/single-valued -1)]
  [dynamic-wind (known-procedure 8)]
  [environment-variables-copy (known-procedure/no-prompt 2)]
  [environment-variables-names (known-procedure/no-prompt 2)]
  [environment-variables-ref (known-procedure/no-prompt 4)]
  [environment-variables-set! (known-procedure/no-prompt 24)]
  [environment-variables? (known-procedure/pure/folding 2)]
  [eof (known-literal eof)]
  [eof-object? (known-procedure/pure/folding 2)]
  [ephemeron-value (known-procedure/no-prompt 14)]
  [ephemeron? (known-procedure/pure/folding 2)]
  [eprintf (known-procedure/single-valued -2)]
  [eq-hash-code (known-procedure/no-prompt 2)]
  [eq? (known-procedure/pure/folding 4)]
  [equal-hash-code (known-procedure/single-valued 2)]
  [equal-hash-code/recur (known-procedure/single-valued 4)]
  [equal-secondary-hash-code (known-procedure/single-valued 2)]
  [equal? (known-procedure/single-valued 4)]
  [equal?/recur (known-procedure/single-valued 8)]
  [equal-always-hash-code (known-procedure/single-valued 2)]
  [equal-always-hash-code/recur (known-procedure/single-valued 4)]
  [equal-always-secondary-hash-code (known-procedure/single-valued 2)]
  [equal-always? (known-procedure/single-valued 4)]
  [equal-always?/recur (known-procedure/single-valued 8)]
  [eqv-hash-code (known-procedure/no-prompt 2)]
  [eqv? (known-procedure/pure/folding 4)]
  [error (known-procedure/no-return -2)]
  [error-contract->adjusted-string (known-procedure/single-valued 4)]
  [error-display-handler (known-procedure/single-valued 3)]
  [error-escape-handler (known-procedure/single-valued 3)]
  [error-message-adjuster-key (known-constant)]
  [error-message->adjusted-string (known-procedure/single-valued 16)]
  [error-module-path->string-handler (known-procedure/single-valued 3)]
  [error-print-context-length (known-procedure/single-valued 3)]
  [error-print-source-location (known-procedure/single-valued 3)]
  [error-print-width (known-procedure/single-valued 3)]
  [error-syntax->name-handler (known-procedure/single-valued 3)]
  [error-syntax->string-handler (known-procedure/single-valued 3)]
  [error-value->string-handler (known-procedure/single-valued 3)]
  [eval-jit-enabled (known-procedure/single-valued 3)]
  [even? (known-procedure/folding 2)]
  [evt? (known-procedure/pure/folding 2)]
  [exact->inexact (known-procedure/folding 2)]
  [exact-integer? (known-procedure/pure/folding 2)]
  [exact-nonnegative-integer? (known-procedure/pure/folding 2)]
  [exact-positive-integer? (known-procedure/pure/folding 2)]
  [exact? (known-procedure/folding 2)]
  [executable-yield-handler (known-procedure/single-valued 3)]
  [exit (known-procedure 3)]
  [exit-handler (known-procedure/single-valued 3)]
  [exn (known-constant)]
  [exn-classify-errno (known-procedure/single-valued 2)]
  [exn-continuation-marks (known-procedure/single-valued 2)]
  [exn-message (known-procedure/single-valued 2)]
  [exn:break (known-constant)]
  [exn:break-continuation (known-procedure/single-valued 2)]
  [exn:break:hang-up (known-constant)]
  [exn:break:hang-up? (known-procedure/pure/folding 2)]
  [exn:break:terminate (known-constant)]
  [exn:break:terminate? (known-procedure/pure/folding 2)]
  [exn:break? (known-procedure/pure/folding 2)]
  [exn:fail (known-constant)] ; not a primitive provcedure due to guard
  [exn:fail:contract (known-constant)]
  [exn:fail:contract:arity (known-constant)]
  [exn:fail:contract:arity? (known-procedure/pure/folding 2)]
  [exn:fail:contract:continuation (known-constant)]
  [exn:fail:contract:continuation? (known-procedure/pure/folding 2)]
  [exn:fail:contract:divide-by-zero (known-constant)]
  [exn:fail:contract:divide-by-zero? (known-procedure/pure/folding 2)]
  [exn:fail:contract:non-fixnum-result (known-constant)]
  [exn:fail:contract:non-fixnum-result? (known-procedure/pure/folding 2)]
  [exn:fail:contract:variable (known-constant)]
  [exn:fail:contract:variable-id (known-procedure/single-valued 2)]
  [exn:fail:contract:variable? (known-procedure/pure/folding 2)]
  [exn:fail:contract? (known-procedure/pure/folding 2)]
  [exn:fail:filesystem (known-constant)]
  [exn:fail:filesystem:errno (known-constant)]
  [exn:fail:filesystem:errno-errno (known-procedure/single-valued 2)]
  [exn:fail:filesystem:errno? (known-procedure/pure/folding 2)]
  [exn:fail:filesystem:exists (known-constant)]
  [exn:fail:filesystem:exists? (known-procedure/single-valued 2)]
  [exn:fail:filesystem:version (known-constant)]
  [exn:fail:filesystem:version? (known-procedure/pure/folding 2)]
  [exn:fail:filesystem? (known-procedure/single-valued 2)]
  [exn:fail:network (known-constant)]
  [exn:fail:network:errno (known-constant)]
  [exn:fail:network:errno-errno (known-procedure/single-valued 2)]
  [exn:fail:network:errno? (known-procedure/pure/folding 2)]
  [exn:fail:network? (known-procedure/single-valued 2)]
  [exn:fail:out-of-memory (known-constant)]
  [exn:fail:out-of-memory? (known-procedure/pure/folding 2)]
  [exn:fail:read (known-constant)]
  [exn:fail:read-srclocs (known-procedure/single-valued 2)]
  [exn:fail:read:eof (known-constant)]
  [exn:fail:read:eof? (known-procedure/pure/folding 2)]
  [exn:fail:read:non-char (known-constant)]
  [exn:fail:read:non-char? (known-procedure/pure/folding 2)]
  [exn:fail:read? (known-procedure/single-valued 2)]
  [exn:fail:unsupported (known-constant)]
  [exn:fail:unsupported? (known-procedure/pure/folding 2)]
  [exn:fail:user (known-constant)]
  [exn:fail:user? (known-procedure/pure/folding 2)]
  [exn:fail? (known-procedure/pure/folding 2)]
  [exn:srclocs-accessor (known-procedure/single-valued 2)]
  [exn:srclocs? (known-procedure/pure/folding 2)]
  [exn? (known-procedure/pure/folding 2)]
  [exp (known-procedure/folding 2)]
  [expand-user-path (known-procedure/no-prompt 2)]
  [explode-path (known-procedure/no-prompt 2)]
  [expt (known-procedure/folding/limited 4 'expt)]
  [file-exists? (known-procedure/no-prompt 2)]
  [file-or-directory-identity (known-procedure/no-prompt 6)]
  [file-or-directory-modify-seconds (known-procedure/no-prompt 14)]
  [file-or-directory-permissions (known-procedure/no-prompt 6)]
  [file-or-directory-stat (known-procedure/no-prompt 6)]
  [file-or-directory-type (known-procedure/no-prompt 6)]
  [file-position (known-procedure/no-prompt 6)]
  [file-position* (known-procedure/no-prompt 2)]
  [file-size (known-procedure/no-prompt 2)]
  [file-stream-buffer-mode (known-procedure/single-valued 6)]
  [file-stream-port? (known-procedure/no-prompt 2)]
  [file-truncate (known-procedure/no-prompt 4)]
  [filesystem-change-evt (known-procedure/no-prompt 6)]
  [filesystem-change-evt-cancel (known-procedure/no-prompt 2)]
  [filesystem-change-evt? (known-procedure/pure/folding 2)]
  [filesystem-change-evt-ready? (known-procedure/no-prompt 2)]
  [filesystem-root-list (known-procedure/no-prompt 1)]
  [find-system-path (known-procedure/no-prompt 2)]
  [fixnum? (known-procedure/pure 2)]
  [floating-point-bytes->real (known-procedure/no-prompt 30)]
  [flonum? (known-procedure/pure/folding 2)]
  [floor (known-procedure/folding 2)]
  [flush-output (known-procedure/single-valued 3)]
  [for-each (known-procedure/single-valued -4)]
  [format (known-procedure/single-valued -2)]
  [fprintf (known-procedure/single-valued -4)]
  [gcd (known-procedure/folding -1)]
  [gensym (known-procedure/single-valued 3)]
  [get-output-bytes (known-procedure/no-prompt 30)]
  [get-output-string (known-procedure/no-prompt 2)]
  [global-port-print-handler (known-procedure/single-valued 3)]
  [handle-evt (known-procedure/no-prompt 4)]
  [handle-evt? (known-procedure/pure/folding 2)]
  [hash (known-procedure/single-valued -1)]
  [hash-clear (known-procedure/single-valued 2)]
  [hash-clear! (known-procedure/single-valued 2)]
  [hash-copy (known-procedure/single-valued 2)]
  [hash-count (known-procedure/single-valued 2)]
  [hash-ephemeron? (known-procedure/single-valued 2)]
  [hash-eq? (known-procedure/single-valued 2)]
  [hash-equal-always? (known-procedure/single-valued 2)]
  [hash-equal? (known-procedure/single-valued 2)]
  [hash-eqv? (known-procedure/single-valued 2)]
  [hash-for-each (known-procedure/single-valued 12)]
  [hash-iterate-first (known-procedure/single-valued 2)]
  [hash-iterate-key (known-procedure/single-valued 12)]
  [hash-iterate-key+value (known-procedure 12)]
  [hash-iterate-next (known-procedure/single-valued 4)]
  [hash-iterate-pair (known-procedure/single-valued 12)]
  [hash-iterate-value (known-procedure/single-valued 12)]
  [hash-keys-subset? (known-procedure/single-valued 4)]
  [hash-map (known-procedure/single-valued 12)]
  [hash-placeholder? (known-procedure/pure/folding 2)]
  [hash-ref (known-procedure 12)]
  [hash-ref-key (known-procedure 12)]
  [hash-remove (known-procedure/single-valued 4)]
  [hash-remove! (known-procedure/single-valued 4)]
  [hash-set (known-procedure/single-valued 8)]
  [hash-set! (known-procedure/single-valued 8)]
  [hash-strong? (known-procedure/single-valued 2)]
  [hash-weak? (known-procedure/single-valued 2)]
  [hash? (known-procedure/pure/folding 2)]
  [hasheq (known-procedure/no-prompt -1)]
  [hashalw (known-procedure/single-valued -1)]
  [hasheqv (known-procedure/no-prompt -1)]
  [imag-part (known-procedure/folding 2)]
  [immutable? (known-procedure/pure/folding 2)]
  [immutable-bytes? (known-procedure/pure/folding 2)]
  [immutable-box? (known-procedure/pure/folding 2)]
  [immutable-hash? (known-procedure/pure/folding 2)]
  [immutable-string? (known-procedure/pure/folding 2)]
  [immutable-vector? (known-procedure/pure/folding 2)]
  [impersonate-box (known-procedure/single-valued -8)]
  [impersonate-channel (known-procedure/single-valued -8)]
  [impersonate-continuation-mark-key (known-procedure/single-valued -8)]
  [impersonate-hash (known-procedure/single-valued -32)]
  [impersonate-procedure (known-procedure/no-prompt -4)]
  [impersonate-procedure* (known-procedure/no-prompt -4)]
  [impersonate-prompt-tag (known-procedure/single-valued -8)]
  [impersonate-struct (known-procedure/single-valued -2)]
  [impersonate-vector (known-procedure/single-valued -8)]
  [impersonate-vector* (known-procedure/single-valued -8)]
  [impersonator-ephemeron (known-procedure/single-valued 2)]
  [impersonator-of? (known-procedure/single-valued 4)]
  [impersonator-prop:application-mark (known-constant)]
  [impersonator-property-accessor-procedure? (known-procedure/single-valued 2)]
  [impersonator-property? (known-procedure/pure/folding 2)]
  [impersonator? (known-procedure/pure/folding 2)]
  [inexact->exact (known-procedure/folding 2)]
  [inexact-real? (known-procedure/pure/folding 2)]
  [inexact? (known-procedure/folding 2)]
  [input-port? (known-procedure/pure/folding 2)]
  [inspector-superior? (known-procedure/no-prompt 4)]
  [inspector? (known-procedure/pure/folding 2)]
  [integer->char (known-procedure/folding 2)]
  [integer->integer-bytes (known-procedure/no-prompt 120)]
  [integer-bytes->integer (known-procedure/no-prompt 60)]
  [integer-length (known-procedure/folding 2)]
  [integer-sqrt (known-procedure/folding 2)]
  [integer-sqrt/remainder (known-procedure/no-prompt/multi 2)]
  [integer? (known-procedure/pure/folding 2)]
  [interned-char? (known-procedure/pure 2)]
  [keyword->immutable-string (known-procedure/no-prompt 2)]
  [keyword->string (known-procedure/no-prompt 2)]
  [keyword<? (known-procedure/folding -2)]
  [keyword? (known-procedure/pure/folding 2)]
  [kill-thread (known-procedure/no-prompt 2)]
  [lcm (known-procedure/folding -1)]
  [length (known-procedure/no-prompt 2)]
  [link-exists? (known-procedure/no-prompt 2)]
  [list (known-procedure/allocates -1)]
  [list* (known-procedure/allocates -2)]
  [list->bytes (known-procedure/no-prompt 2)]
  [list->string (known-procedure/no-prompt 2)]
  [list->vector (known-procedure/no-prompt 2)]
  [list-pair? (known-procedure/pure/folding 2)]
  [list-ref (known-procedure/no-prompt 4)]
  [list-tail (known-procedure/no-prompt 4)]
  [list? (known-procedure/pure/folding 2)]
  [load-on-demand-enabled (known-procedure/single-valued 3)]
  [locale-string-encoding (known-procedure/no-prompt 1)]
  [log (known-procedure/folding 6)]
  [log-all-levels (known-procedure/no-prompt 2)]
  [log-level-evt (known-procedure/no-prompt 2)]
  [log-level? (known-procedure/no-prompt 12)]
  [log-max-level (known-procedure/no-prompt 6)]
  [log-message (known-procedure/no-prompt 120)]
  [log-receiver? (known-procedure/pure/folding 2)]
  [logger-name (known-procedure/no-prompt 2)]
  [logger? (known-procedure/pure/folding 2)]
  [magnitude (known-procedure/folding 2)]
  [make-bytes (known-procedure/no-prompt 6)]
  [make-channel (known-procedure/allocates 1)]
  [make-continuation-mark-key (known-procedure/no-prompt 3)]
  [make-continuation-prompt-tag (known-procedure/no-prompt 3)]
  [make-custodian (known-procedure/no-prompt 3)]
  [make-custodian-box (known-procedure/no-prompt 4)]
  [make-derived-parameter (known-procedure/single-valued 56)]
  [make-directory (known-procedure/no-prompt 6)]
  [make-environment-variables (known-procedure/no-prompt -1)]
  [make-ephemeron (known-procedure/allocates 4)]
  [make-ephemeron-hash (known-procedure/single-valued 3)]
  [make-ephemeron-hasheq (known-procedure/no-prompt 3)]
  [make-ephemeron-hashalw (known-procedure/no-prompt 3)]
  [make-ephemeron-hasheqv (known-procedure/no-prompt 3)]
  [make-file-or-directory-link (known-procedure/no-prompt 4)]
  [make-hash (known-procedure/single-valued 3)]
  [make-hash-placeholder (known-procedure/no-prompt 2)]
  [make-hasheq (known-procedure/no-prompt 3)]
  [make-hasheq-placeholder (known-procedure/no-prompt 2)]
  [make-hashalw (known-procedure/no-prompt 3)]
  [make-hashalw-placeholder (known-procedure/no-prompt 2)]
  [make-hasheqv (known-procedure/no-prompt 3)]
  [make-hasheqv-placeholder (known-procedure/no-prompt 2)]
  [make-immutable-hash (known-procedure/single-valued 3)]
  [make-immutable-hasheq (known-procedure/no-prompt 3)]
  [make-immutable-hashalw (known-procedure/no-prompt 3)]
  [make-immutable-hasheqv (known-procedure/no-prompt 3)]
  [make-impersonator-property (known-procedure/no-prompt 30)]
  [make-input-port (known-procedure/single-valued 2032)]
  [make-inspector (known-procedure/no-prompt 3)]
  [make-known-char-range-list (known-procedure/pure 1)]
  [make-log-receiver (known-procedure/no-prompt -4)]
  [make-logger (known-procedure/no-prompt -1)]
  [make-output-port (known-procedure/single-valued 4080)]
  [make-parameter (known-procedure/single-valued 30)]
  [make-phantom-bytes (known-procedure/no-prompt 2)]
  [make-pipe (known-procedure/no-prompt/multi 15)]
  [make-placeholder (known-procedure/allocates 2)]
  [make-plumber (known-procedure/allocates 1)]
  [make-polar (known-procedure/folding 4)]
  [make-prefab-struct (known-procedure/single-valued -2)]
  [make-pseudo-random-generator (known-procedure/no-prompt 1)] ; not pure, depends on (current-milliseconds)
  [make-reader-graph (known-procedure/single-valued 2)]
  [make-rectangular (known-procedure/folding 4)]
  [make-security-guard (known-procedure/single-valued 24)]
  [make-semaphore (known-procedure/no-prompt 3)]
  [make-shared-bytes (known-procedure/no-prompt 6)]
  [make-sibling-inspector (known-procedure/no-prompt 3)]
  [make-string (known-procedure/no-prompt 6)]
  [make-struct-field-accessor (known-procedure/single-valued 60)]
  [make-struct-field-mutator (known-procedure/single-valued 60)]
  [make-struct-type (known-procedure 4080)]
  [make-struct-type-property (known-procedure 254)]
  [make-thread-cell (known-procedure/allocates 6)]
  [make-thread-group (known-procedure/no-prompt 3)]
  [make-vector (known-procedure/no-prompt 6)]
  [make-weak-box (known-procedure/allocates 2)]
  [make-weak-hash (known-procedure/single-valued 3)]
  [make-weak-hasheq (known-procedure/no-prompt 3)]
  [make-weak-hashalw (known-procedure/no-prompt 3)]
  [make-weak-hasheqv (known-procedure/no-prompt 3)]
  [make-will-executor (known-procedure/allocates 1)]
  [map (known-procedure/single-valued -4)]
  [max (known-procedure/folding -2)]
  [mcar (known-procedure/has-unsafe 2 'unsafe-mcar)]
  [mcdr (known-procedure/has-unsafe 2 'unsafe-mcdr)]
  [mcons (known-procedure/allocates 4)]
  [memory-order-acquire (known-procedure/single-valued 1)]
  [memory-order-release (known-procedure/single-valued 1)]
  [memq (known-procedure/single-valued 4)]
  [memv (known-procedure/single-valued 4)]
  [min (known-procedure/folding -2)]
  [modulo (known-procedure/folding 4)]
  [mpair? (known-procedure/pure/folding 2)]
  [mutable-bytes? (known-procedure/pure/folding 2)]
  [mutable-box? (known-procedure/pure/folding 2)]
  [mutable-hash? (known-procedure/pure/folding 2)]
  [mutable-string? (known-procedure/pure/folding 2)]
  [mutable-vector? (known-procedure/pure/folding 2)]
  [nack-guard-evt (known-procedure/no-prompt 2)]
  [negative? (known-procedure/folding 2)]
  [never-evt (known-authentic)]
  [newline (known-procedure/single-valued 3)]
  [not (known-procedure/pure/folding 2)]
  [null (known-literal '())]
  [null? (known-procedure/pure/folding 2)]
  [number->string (known-procedure/no-prompt 6)]
  [number? (known-procedure/pure/folding 2)]
  [numerator (known-procedure/folding 2)]
  [object-name (known-procedure/single-valued 2)]
  [odd? (known-procedure/folding 2)]
  [open-input-bytes (known-procedure/no-prompt 6)]
  [open-input-file (known-procedure/no-prompt 14)]
  [open-input-output-file (known-procedure/no-prompt/multi 14)]
  [open-input-string (known-procedure/no-prompt 6)]
  [open-output-bytes (known-procedure/no-prompt 3)]
  [open-output-file (known-procedure/no-prompt 14)]
  [open-output-string (known-procedure/no-prompt 3)]
  [ormap (known-procedure -4)]
  [output-port? (known-procedure/pure/folding 2)]
  [pair? (known-procedure/pure/folding 2)]
  [parameter-procedure=? (known-procedure/single-valued 4)]
  [parameter? (known-procedure/pure/folding 2)]
  [parameterization? (known-procedure/pure/folding 2)]
  [path->bytes (known-procedure/no-prompt 2)]
  [path->complete-path (known-procedure/no-prompt 6)]
  [path->directory-path (known-procedure/no-prompt 2)]
  [path->string (known-procedure/no-prompt 2)]
  [path-convention-type (known-procedure/no-prompt 2)]
  [path-element->bytes (known-procedure/no-prompt 2)]
  [path-element->string (known-procedure/no-prompt 2)]
  [path-for-some-system? (known-procedure/pure/folding 2)]
  [path<? (known-procedure/no-prompt -2)]
  [path? (known-procedure/pure 2)]
  [peek-byte (known-procedure/single-valued 7)]
  [peek-byte-or-special (known-procedure/single-valued 63)]
  [peek-bytes (known-procedure/single-valued 12)]
  [peek-bytes! (known-procedure/single-valued 60)]
  [peek-bytes-avail! (known-procedure/single-valued 124)]
  [peek-bytes-avail!* (known-procedure/single-valued 124)]
  [peek-bytes-avail!/enable-break (known-procedure/single-valued 124)]
  [peek-char (known-procedure/single-valued 7)]
  [peek-char-or-special (known-procedure/single-valued 31)]
  [peek-string (known-procedure/single-valued 12)]
  [peek-string! (known-procedure/single-valued 60)]
  [phantom-bytes? (known-procedure/pure/folding 2)]
  [pipe-content-length (known-procedure/no-prompt 2)]
  [pipe-port? (known-procedure/no-prompt 2)]  
  [placeholder-get (known-procedure/no-prompt 2)]
  [placeholder-set! (known-procedure/no-prompt 4)]
  [placeholder? (known-procedure/pure/folding 2)]
  [plumber-add-flush! (known-procedure/single-valued 12)]
  [plumber-flush-all (known-procedure/single-valued 2)]
  [plumber-flush-handle-remove! (known-procedure/no-prompt 2)]
  [plumber-flush-handle? (known-procedure/pure/folding 2)]
  [plumber? (known-procedure/pure/folding 2)]
  [poll-guard-evt (known-procedure/single-valued 2)]
  [port-closed-evt (known-procedure/single-valued 2)]
  [port-closed? (known-procedure/single-valued 2)]
  [port-commit-peeked (known-procedure/single-valued 24)]
  [port-count-lines! (known-procedure/single-valued 2)]
  [port-count-lines-enabled (known-procedure/single-valued 3)]
  [port-counts-lines? (known-procedure/single-valued 2)]
  [port-display-handler (known-procedure/single-valued 6)]
  [port-file-identity (known-procedure/single-valued 2)]
  [port-file-stat (known-procedure/single-valued 2)]
  [port-file-unlock (known-procedure/single-valued 2)]
  [port-next-location (known-procedure 2)]
  [port-print-handler (known-procedure/single-valued 6)]
  [port-progress-evt (known-procedure/single-valued 3)]
  [port-provides-progress-evts? (known-procedure/single-valued 2)]
  [port-read-handler (known-procedure/single-valued 6)]
  [port-try-file-lock? (known-procedure/single-valued 4)]
  [port-waiting-peer? (known-procedure/single-valued 2)]
  [port-write-handler (known-procedure/single-valued 6)]
  [port-writes-atomic? (known-procedure/single-valued 2)]
  [port-writes-special? (known-procedure/single-valued 2)]
  [positive? (known-procedure/folding 2)]
  [prefab-key->struct-type (known-procedure/no-prompt 4)]
  [prefab-key? (known-procedure/no-prompt 2)] ; not pure, the argument may have a mutable vector
  [prefab-struct-key (known-procedure/no-prompt 2)]
  [prefab-struct-type-key+field-count (known-procedure/no-prompt 2)]
  [pregexp (known-procedure/no-prompt-up-to 6 1)]
  [pregexp? (known-procedure/pure/folding 2)]
  [primitive-closure? (known-procedure/pure/folding 2)]
  [primitive-result-arity (known-procedure/single-valued 2)]
  [primitive? (known-procedure/pure 2)]
  [print (known-procedure/single-valued 14)]
  [print-as-expression (known-procedure/succeeds 3)]
  [print-boolean-long-form (known-procedure/succeeds 3)]
  [print-box (known-procedure/succeeds 3)]
  [print-graph (known-procedure/succeeds 3)]
  [print-hash-table (known-procedure/succeeds 3)]
  [print-mpair-curly-braces (known-procedure/succeeds 3)]
  [print-pair-curly-braces (known-procedure/succeeds 3)]
  [print-reader-abbreviations (known-procedure/succeeds 3)]
  [print-struct (known-procedure/succeeds 3)]
  [print-syntax-width (known-procedure/succeeds 3)]
  [print-unreadable (known-procedure/succeeds 3)]
  [print-vector-length (known-procedure/succeeds 3)]
  [printf (known-procedure/single-valued -2)]
  [procedure->method (known-procedure/no-prompt 2)]
  [procedure-arity (known-procedure/single-valued 2)]
  [procedure-arity-mask (known-procedure/single-valued 2)]
  [procedure-arity-includes? (known-procedure/single-valued 12)]
  [procedure-arity? (known-procedure/pure/folding 2)]
  [procedure-closure-contents-eq? (known-procedure/single-valued 4)]
  [procedure-extract-target (known-procedure/single-valued 2)]
  [procedure-impersonator*? (known-procedure/pure/folding 2)]
  [procedure-realm (known-procedure/single-valued 2)]
  [procedure-reduce-arity (known-procedure/single-valued 28)]
  [procedure-reduce-arity-mask (known-procedure/single-valued 28)]
  [procedure-rename (known-procedure/single-valued 12)]
  [procedure-result-arity (known-procedure/single-valued 2)]
  [procedure-specialize (known-procedure/single-valued 2)]
  [procedure-struct-type? (known-procedure/single-valued 2)]
  [procedure? (known-procedure/pure/folding 2)]
  [progress-evt? (known-procedure/single-valued 6)]
  [prop:arity-string (known-constant)]
  [prop:authentic (known-struct-type-property/immediate-guard)]
  [prop:checked-procedure (known-constant)]
  [prop:custom-print-quotable (known-constant)]
  [prop:custom-write (known-struct-type-property/immediate-guard)]
  [prop:equal+hash (known-struct-type-property/immediate-guard)]
  [prop:evt (known-struct-type-property/immediate-guard)]
  [prop:exn:srclocs (known-constant)]
  [prop:impersonator-of (known-constant)]
  [prop:incomplete-arity (known-constant)]
  [prop:input-port (known-constant)]
  [prop:method-arity-error (known-constant)]
  [prop:object-name (known-constant)]
  [prop:output-port (known-constant)]
  [prop:procedure (known-struct-type-property/immediate-guard)]
  [prop:sealed (known-struct-type-property/immediate-guard)]
  [pseudo-random-generator->vector (known-procedure/no-prompt 2)]
  [pseudo-random-generator-vector? (known-procedure/no-prompt 2)]
  [pseudo-random-generator? (known-procedure/pure/folding 2)]
  [quotient (known-procedure/folding 4)]
  [quotient/remainder (known-procedure/no-prompt/multi 4)]
  [raise (known-procedure/no-return 6)]
  [raise-argument-error (known-procedure/no-return -8)]
  [raise-argument-error* (known-procedure/no-return -16)]
  [raise-arguments-error (known-procedure/no-return -4)]
  [raise-arguments-error* (known-procedure/no-return -8)]
  [raise-arity-error (known-procedure/no-return -4)]
  [raise-arity-error* (known-procedure/no-return -8)]
  [raise-arity-mask-error (known-procedure/no-return -4)]
  [raise-arity-mask-error* (known-procedure/no-return -8)]
  [raise-mismatch-error (known-procedure/no-return -8)]
  [raise-range-error (known-procedure/no-return 384)]
  [raise-range-error* (known-procedure/no-return 768)]
  [raise-result-error (known-procedure/no-return -8)]
  [raise-result-error* (known-procedure/no-return -16)]
  [raise-result-arity-error (known-procedure/no-return -8)]
  [raise-result-arity-error* (known-procedure/no-return -16)]
  [raise-type-error (known-procedure/no-return -8)]
  [raise-user-error (known-procedure/no-return -2)]
  [random (known-procedure/no-prompt 15)]
  [random-seed (known-procedure/no-prompt 2)]
  [rational? (known-procedure/pure/folding 2)]
  [read-accept-bar-quote (known-procedure/succeeds 3)]
  [read-byte (known-procedure/single-valued 3)]
  [read-byte-or-special (known-procedure/single-valued 15)]
  [read-bytes (known-procedure/single-valued 6)]
  [read-bytes! (known-procedure/single-valued 30)]
  [read-bytes-avail! (known-procedure/single-valued 30)]
  [read-bytes-avail!* (known-procedure/single-valued 30)]
  [read-bytes-avail!/enable-break (known-procedure/single-valued 30)]
  [read-bytes-line (known-procedure/single-valued 7)]
  [read-case-sensitive (known-procedure/succeeds 3)]
  [read-char (known-procedure/single-valued 3)]
  [read-char-or-special (known-procedure/single-valued 15)]
  [read-line (known-procedure/single-valued 7)]
  [read-on-demand-source (known-procedure/single-valued 3)]
  [read-string (known-procedure/single-valued 6)]
  [read-string! (known-procedure/single-valued 30)]
  [real->double-flonum (known-procedure/folding 2)]
  [real->floating-point-bytes (known-procedure/single-valued 60)]
  [real->single-flonum (known-procedure/single-valued 2)]
  [real-part (known-procedure/folding 2)]
  [real? (known-procedure/pure/folding 2)]
  [regexp (known-procedure/no-prompt-up-to 6 1)]
  [regexp-capture-group-count (known-procedure/single-valued 2)]
  [regexp-match (known-procedure/single-valued 124)]
  [regexp-match-peek (known-procedure/single-valued 124)]
  [regexp-match-peek-immediate (known-procedure/single-valued 124)]
  [regexp-match-peek-positions (known-procedure/single-valued 124)]
  [regexp-match-peek-positions-immediate (known-procedure/single-valued 124)]
  [regexp-match-peek-positions-immediate/end (known-procedure/single-valued 252)]
  [regexp-match-peek-positions/end (known-procedure 252)]
  [regexp-match-positions (known-procedure/single-valued 124)]
  [regexp-match-positions/end (known-procedure 252)]
  [regexp-match/end (known-procedure 252)]
  [regexp-match? (known-procedure/single-valued 124)]
  [regexp-max-lookbehind (known-procedure/single-valued 2)]
  [regexp-replace (known-procedure/single-valued 24)]
  [regexp-replace* (known-procedure/single-valued 120)]
  [regexp? (known-procedure/pure/folding 2)]
  [relative-path? (known-procedure/no-prompt 2)]
  [remainder (known-procedure/folding 4)]
  [rename-file-or-directory (known-procedure/no-prompt 12)]
  [replace-evt (known-procedure/single-valued 4)]
  [resolve-path (known-procedure/no-prompt 2)]
  [reverse (known-procedure/no-prompt 2)]
  [round (known-procedure/folding 2)]
  [seconds->date (known-procedure/no-prompt 6)]
  [security-guard? (known-procedure/pure/folding 2)]
  [semaphore-peek-evt (known-procedure/no-prompt 2)]
  [semaphore-peek-evt? (known-procedure/pure/folding 2)]
  [semaphore-post (known-procedure/no-prompt 2)]
  [semaphore-try-wait? (known-procedure/no-prompt 2)]
  [semaphore-wait (known-procedure/no-prompt 2)]
  [semaphore-wait/enable-break (known-procedure/no-prompt 2)]
  [semaphore? (known-procedure/pure/folding 2)]
  [set-box! (known-procedure/single-valued 4)]
  [set-box*! (known-procedure/has-unsafe 4 'unsafe-set-box*!)]
  [set-mcar! (known-procedure/has-unsafe 4 'unsafe-set-mcar!)]
  [set-mcdr! (known-procedure/has-unsafe 4 'unsafe-set-mcdr!)]
  [set-phantom-bytes! (known-procedure/no-prompt 4)]
  [set-port-next-location! (known-procedure/single-valued 16)]
  [sha1-bytes (known-procedure/single-valued 14)]
  [sha224-bytes (known-procedure/single-valued 14)]
  [sha256-bytes (known-procedure/single-valued 14)]
  [shared-bytes (known-procedure/single-valued -1)]
  [shell-execute (known-procedure/single-valued 32)]
  [simplify-path (known-procedure/no-prompt 6)]
  [sin (known-procedure/folding 2)]
  [single-flonum? (known-procedure/pure/folding 2)]
  [single-flonum-available? (known-procedure/pure 1)]
  [sleep (known-procedure/no-prompt 3)]
  [split-path (known-procedure/no-prompt/multi 2)]
  [sqrt (known-procedure/folding 2)]
  [srcloc (known-procedure/has-unsafe 32 'unsafe-make-srcloc)]
  [srcloc->string (known-procedure/single-valued 2)]
  [srcloc-column (known-procedure/single-valued 2)]
  [srcloc-line (known-procedure/single-valued 2)]
  [srcloc-position (known-procedure/single-valued 2)]
  [srcloc-source (known-procedure/single-valued 2)]
  [srcloc-span (known-procedure/single-valued 2)]
  [srcloc? (known-procedure/pure/folding 2)]
  [stencil-vector (known-procedure/no-prompt -2)]
  [stencil-vector? (known-procedure/pure/folding 2)]
  [stencil-vector-length (known-procedure/folding 2)]
  [stencil-vector-mask (known-procedure/folding 2)]
  [stencil-vector-mask-width (known-procedure/pure/folding 1)]
  [stencil-vector-ref (known-procedure/no-prompt 4)]
  [stencil-vector-set! (known-procedure/no-prompt 8)]
  [stencil-vector-update (known-procedure/no-prompt -8)]
  [string (known-procedure/no-prompt -1)]
  [string->bytes/latin-1 (known-procedure/no-prompt 30)]
  [string->bytes/locale (known-procedure/no-prompt 30)]
  [string->bytes/utf-8 (known-procedure/no-prompt 30)]
  [string->immutable-string (known-procedure/no-prompt 2)]
  [string->keyword (known-procedure/no-prompt 2)]
  [string->list (known-procedure/no-prompt 2)]
  [string->number (known-procedure/no-prompt 62)]
  [string->path (known-procedure/no-prompt 2)]
  [string->path-element (known-procedure/no-prompt 6)]
  [string->symbol (known-procedure/no-prompt 2)]
  [string->uninterned-symbol (known-procedure/no-prompt 2)]
  [string->unreadable-symbol (known-procedure/no-prompt 2)]
  [string-append (known-procedure/no-prompt -1)]
  [string-append-immutable (known-procedure/no-prompt -1)]
  [string-ci<=? (known-procedure/no-prompt -2)]
  [string-ci<? (known-procedure/no-prompt -2)]
  [string-ci=? (known-procedure/no-prompt -2)]
  [string-ci>=? (known-procedure/no-prompt -2)]
  [string-ci>? (known-procedure/no-prompt -2)]
  [string-copy (known-procedure/no-prompt 2)]
  [string-copy! (known-procedure/no-prompt 56)]
  [string-downcase (known-procedure/no-prompt 2)]
  [string-fill! (known-procedure/no-prompt 4)]
  [string-foldcase (known-procedure/no-prompt 2)]
  [string-grapheme-count (known-procedure/no-prompt 14)]
  [string-grapheme-span (known-procedure/no-prompt 12)]
  [string-length (known-procedure/no-prompt 2)]
  [string-locale-ci<? (known-procedure/no-prompt -2)]
  [string-locale-ci=? (known-procedure/no-prompt -2)]
  [string-locale-ci>? (known-procedure/no-prompt -2)]
  [string-locale-downcase (known-procedure/no-prompt 2)]
  [string-locale-upcase (known-procedure/no-prompt 2)]
  [string-locale<? (known-procedure/no-prompt -2)]
  [string-locale=? (known-procedure/no-prompt -2)]
  [string-locale>? (known-procedure/no-prompt -2)]
  [string-normalize-nfc (known-procedure/no-prompt 2)]
  [string-normalize-nfd (known-procedure/no-prompt 2)]
  [string-normalize-nfkc (known-procedure/no-prompt 2)]
  [string-normalize-nfkd (known-procedure/no-prompt 2)]
  [string-port? (known-procedure/no-prompt 2)]
  [string-ref (known-procedure/no-prompt 4)]
  [string-set! (known-procedure/no-prompt 8)]
  [string-titlecase (known-procedure/no-prompt 2)]
  [string-upcase (known-procedure/no-prompt 2)]
  [string-utf-8-length (known-procedure/no-prompt 14)]
  [string<=? (known-procedure/no-prompt -2)]
  [string<? (known-procedure/no-prompt -2)]
  [string=? (known-procedure/no-prompt -2)]
  [string>=? (known-procedure/no-prompt -2)]
  [string>? (known-procedure/no-prompt -2)]
  [string? (known-procedure/pure/folding 2)]
  [struct->vector (known-procedure/single-valued 6)]
  [struct-accessor-procedure? (known-procedure/pure/folding 2)]
  [struct-constructor-procedure? (known-procedure/pure/folding 2)]
  [struct-info (known-procedure 2)]
  [struct-mutator-procedure? (known-procedure/pure/folding 2)]
  [struct-predicate-procedure? (known-procedure/pure/folding 2)]
  [struct-type-authentic? (known-procedure/single-valued 2)]
  [struct-type-info (known-procedure 2)]
  [struct-type-make-constructor (known-procedure/single-valued 6)]
  [struct-type-make-predicate (known-procedure/single-valued 2)]
  [struct-type-property-accessor-procedure? (known-procedure/single-valued 2)]
  [struct-type-property-predicate-procedure? (known-procedure/single-valued 6)]
  [struct-type-property? (known-procedure/no-prompt 2)]
  [struct-type-sealed? (known-procedure/single-valued 2)]
  [struct-type? (known-procedure/no-prompt 2)]
  [struct:arity-at-least (known-constant)]
  [struct:date (known-constant)]
  [struct:date* (known-constant)]
  [struct:exn (known-constant)]
  [struct:exn:break (known-constant)]
  [struct:exn:break:hang-up (known-constant)]
  [struct:exn:break:terminate (known-constant)]
  [struct:exn:fail (known-constant)]
  [struct:exn:fail:contract (known-constant)]
  [struct:exn:fail:contract:arity (known-constant)]
  [struct:exn:fail:contract:continuation (known-constant)]
  [struct:exn:fail:contract:divide-by-zero (known-constant)]
  [struct:exn:fail:contract:non-fixnum-result (known-constant)]
  [struct:exn:fail:contract:variable (known-constant)]
  [struct:exn:fail:filesystem (known-constant)]
  [struct:exn:fail:filesystem:errno (known-constant)]
  [struct:exn:fail:filesystem:exists (known-constant)]
  [struct:exn:fail:filesystem:version (known-constant)]
  [struct:exn:fail:network (known-constant)]
  [struct:exn:fail:network:errno (known-constant)]
  [struct:exn:fail:out-of-memory (known-constant)]
  [struct:exn:fail:read (known-constant)]
  [struct:exn:fail:read:eof (known-constant)]
  [struct:exn:fail:read:non-char (known-constant)]
  [struct:exn:fail:unsupported (known-constant)]
  [struct:exn:fail:user (known-constant)]
  [struct:srcloc (known-constant)]
  [struct? (known-procedure/no-prompt 2)] ; not pure, depends on (current-inspector)
  [sub1 (known-procedure/folding 2)]
  [subbytes (known-procedure/no-prompt 12)]
  [subprocess (known-procedure -16)]
  [subprocess-group-enabled (known-procedure/single-valued 3)]
  [subprocess-kill (known-procedure/single-valued 4)]
  [subprocess-pid (known-procedure/single-valued 2)]
  [subprocess-status (known-procedure/single-valued 2)]
  [subprocess-wait (known-procedure/single-valued 2)]
  [subprocess? (known-procedure/single-valued 2)]
  [substring (known-procedure/no-prompt 12)]
  [symbol->immutable-string (known-procedure/no-prompt 2)]
  [symbol->string (known-procedure/no-prompt 2)]
  [symbol-interned? (known-procedure/no-prompt 2)]
  [symbol-unreadable? (known-procedure/no-prompt 2)]
  [symbol<? (known-procedure/no-prompt -2)]
  [symbol? (known-procedure/pure/folding 2)]
  [sync (known-procedure -1)]
  [sync/enable-break (known-procedure -1)]
  [sync/timeout (known-procedure -2)]
  [sync/timeout/enable-break (known-procedure -2)]
  [syntax->datum (known-procedure/no-prompt 2)]
  [syntax-column (known-procedure/no-prompt 2)]
  [syntax-e (known-procedure/no-prompt 2)]
  [syntax-line (known-procedure/no-prompt 2)]
  [syntax-position (known-procedure/no-prompt 2)]
  [syntax-property (known-procedure/no-prompt 28)]
  [syntax-property-symbol-keys (known-procedure/no-prompt 2)]
  [syntax-source (known-procedure/no-prompt 2)]
  [syntax-span (known-procedure/no-prompt 2)]
  [syntax? (known-procedure/pure/folding 2)]
  [system-big-endian? (known-procedure/pure 1)]
  [system-idle-evt (known-procedure/pure 1)]
  [system-language+country (known-procedure/no-prompt 1)]
  [system-library-subpath (known-procedure/no-prompt 3)]
  [system-path-convention-type (known-procedure/pure 1)]
  [system-type (known-procedure/no-prompt 3)]
  [tan (known-procedure/folding 2)]
  [terminal-file-position (known-procedure/no-prompt 1)]
  [terminal-port? (known-procedure/no-prompt 2)]
  [thread (known-procedure/single-valued 6)]
  [thread-cell-ref (known-procedure/no-prompt 2)]
  [thread-cell-set! (known-procedure/no-prompt 4)]
  [thread-cell-values? (known-procedure/pure/folding 2)]
  [thread-cell? (known-procedure/pure/folding 2)]
  [thread-dead-evt (known-procedure/no-prompt 2)]
  [thread-dead? (known-procedure/no-prompt 2)]
  [thread-group? (known-procedure/pure/folding 2)]
  [thread-receive (known-procedure/no-prompt 1)]
  [thread-receive-evt (known-procedure/pure 1)]
  [thread-resume (known-procedure/no-prompt 6)]
  [thread-resume-evt (known-procedure/no-prompt 2)]
  [thread-rewind-receive (known-procedure/no-prompt 2)]
  [thread-running? (known-procedure/no-prompt 2)]
  [thread-send (known-procedure/no-prompt 12)]
  [thread-suspend (known-procedure/no-prompt 2)]
  [thread-suspend-evt (known-procedure/no-prompt 2)]
  [thread-try-receive (known-procedure/no-prompt 1)]
  [thread-wait (known-procedure/no-prompt 6)]
  [thread/suspend-to-kill (known-procedure/single-valued 2)]
  [thread? (known-procedure/pure/folding 2)]
  [time-apply (known-procedure 4)]
  [true-object? (known-procedure/pure/folding 2)]
  [truncate (known-procedure/folding 2)]
  [unbox (known-procedure/single-valued 2)]
  [unbox* (known-procedure/has-unsafe 2 'unsafe-unbox*)]
  [uncaught-exception-handler (known-procedure/single-valued 3)]
  [unquoted-printing-string (known-procedure/no-prompt 2)]
  [unquoted-printing-string-value (known-procedure/single-valued 2)]
  [unquoted-printing-string? (known-procedure/no-prompt 2)]
  [values (known-procedure/no-prompt/multi -1)] ; not marked as pure, because it is not single valued
  [vector (known-procedure/allocates -1)]
  [vector->immutable-vector (known-procedure/single-valued 2)]
  [vector->list (known-procedure/single-valued 2)]
  [vector->pseudo-random-generator (known-procedure/single-valued 2)]
  [vector->pseudo-random-generator! (known-procedure/single-valued 4)]
  [vector->values (known-procedure 14)]
  [vector-append (known-procedure/single-valued -1)]
  [vector-cas! (known-procedure/has-unsafe 16 'unsafe-vector*-cas!)]
  [vector-copy (known-procedure/single-valued 14)]
  [vector-copy! (known-procedure/single-valued 56)]
  [vector-fill! (known-procedure/single-valued 4)]
  [vector-immutable (known-procedure/allocates -1)]
  [vector-length (known-procedure/no-prompt 2)]
  [vector-ref (known-procedure/single-valued 4)]
  [vector-set! (known-procedure/single-valued 8)]
  [vector-set-performance-stats! (known-procedure/single-valued 6)]
  [vector-set/copy (known-procedure/single-valued 8)]
  [vector? (known-procedure/pure/folding 2)]
  [vector-extend (known-procedure/single-valued 12)]
  [vector*-append (known-procedure/has-unsafe -1 'unsafe-vector*-append)]
  [vector*-copy (known-procedure/has-unsafe 14 'unsafe-vector*-copy)]
  [vector*-length (known-procedure/has-unsafe 2 'unsafe-vector*-length)]
  [vector*-ref (known-procedure/has-unsafe 4 'unsafe-vector*-ref)]
  [vector*-set! (known-procedure/has-unsafe 8 'unsafe-vector*-set!)]
  [vector*-set/copy (known-procedure/has-unsafe 8 'unsafe-vector*-set/copy)]
  [vector*-extend (known-procedure/single-valued 12)]
  [version (known-procedure/pure 1)]
  [void (known-procedure/pure/folding -1)]
  [void? (known-procedure/pure/folding 2)]
  [weak-box-value (known-procedure/no-prompt 6)]
  [weak-box? (known-procedure/pure/folding 2)]
  [will-execute (known-procedure 2)]
  [will-executor? (known-procedure/pure/folding 2)]
  [will-register (known-procedure/single-valued 8)]
  [will-try-execute (known-procedure 6)]
  [with-input-from-file (known-procedure 12)]
  [with-output-to-file (known-procedure 28)]
  [wrap-evt (known-procedure/single-valued 4)]
  [write (known-procedure/single-valued 6)]
  [write-byte (known-procedure/single-valued 6)]
  [write-bytes (known-procedure/single-valued 30)]
  [write-bytes-avail (known-procedure/single-valued 30)]
  [write-bytes-avail* (known-procedure/single-valued 30)]
  [write-bytes-avail-evt (known-procedure/single-valued 30)]
  [write-bytes-avail/enable-break (known-procedure/single-valued 30)]
  [write-char (known-procedure/single-valued 6)]
  [write-special (known-procedure/single-valued 6)]
  [write-special-avail* (known-procedure/single-valued 6)]
  [write-special-evt (known-procedure/single-valued 6)]
  [write-string (known-procedure/single-valued 30)]
  [zero? (known-procedure/folding 2)])
