#lang racket/base

(require (for-syntax racket/base
                     "version-misc.rkt"))

;; version-case: SYNTAX
;; Conditionally include code based on current version number.
;; Usage:
;;
;; (version-case [clause code] ...
;;               [else ...])
;;
;; where clause has access to the mzscheme primitives.  In addition,
;; the following functions are available:
;;
;;     version<=: string string -> boolean
;;     version>=: string string -> boolean
;;     version=: string string -> boolean
;;     version<: string string -> boolean
;;     version>: string string -> boolean
;;
;; to make it easier to build the conditional clauses.

(require "private/new-version-case.rkt")
(provide (all-from-out "private/new-version-case.rkt"))
