4449
((3) 0 () 12 ((q lib "net/ssl.rhm") (q 3632 . 31) (q 4305 . 29) (q 2921 . 15) (q 1294 . 6) (q 5056 . 16) (q 3275 . 19) (q 0 . 6) (q 93 . 9) (q 1510 . 7) (q 153 . 20) (q 4865 . 9)) () (h ! (equal) ((c def c (c (? . 0) q Context (Context.VerifySource.handle #f))) c (? . 1)) ((c def c (c (? . 0) q Context (Context.seal #f))) q (5568 . 3)) ((c def c (c (? . 0) q Listener (Listener.load_certificate_chain #f))) c (? . 3)) ((c def c (c (? . 0) q Context (Context.KeyKind.rsa #f))) c (? . 2)) ((c def c (c (? . 0) q Context (Context.load_verify_source #f))) c (? . 1)) ((c def c (c (? . 0) q Context (Context.PrivateKey.pem_bytes #f))) c (? . 2)) ((c def c (c (? . 0) q Listener (Listener.load_private_key #f))) c (? . 3)) ((c def c (c (? . 0) q Port (Port.peer_certificate_hostnames #f))) q (1116 . 4)) ((c def c (c (? . 0) q Port (Port.peer_issuer_name #f))) c (? . 4)) ((c def c (c (? . 0) q Context (Context.KeyKind rhombus/annot))) c (? . 2)) ((c def c (c (? . 0) q Context rhombus/annot)) c (? . 6)) ((c def c (c (? . 0) q unavailable_reason)) c (? . 7)) ((c def c (c (? . 0) q Listener)) q (1965 . 10)) ((c def c (c (? . 0) q Context (Context.VerifyMode.never #f))) c (? . 5)) ((c def c (c (? . 0) q Context (Context.VerifySource.file #f))) c (? . 1)) ((c def c (c (? . 0) q Port (Port.abandon #f))) c (? . 9)) ((c def c (c (? . 0) q Port (Port.peer_subject_name #f))) c (? . 4)) ((c def c (c (? . 0) q Context (Context.VerifySource rhombus/annot))) c (? . 1)) ((c def c (c (? . 0) q Context (Context.VerifySource.default #f))) c (? . 1)) ((c def c (c (? . 0) q Listener (Listener.close #f))) q (2629 . 3)) ((c def c (c (? . 0) q Context (Context.set_verify #f))) c (? . 5)) ((c def c (c (? . 0) q Context (Context.VerifySource.mac_keychain #f))) c (? . 1)) ((c def c (c (? . 0) q Context (Context.Client rhombus/annot))) c (? . 6)) ((c def c (c (? . 0) q Context (Context.load_certificate_chain #f))) c (? . 11)) ((c def c (c (? . 0) q Context (Context.PrivateKey.der #f))) c (? . 2)) ((c def c (c (? . 0) q Port rhombus/annot)) c (? . 8)) ((c def c (c (? . 0) q Context (Context.VerifySource.win_store #f))) c (? . 1)) ((c def c (c (? . 0) q Context (Context.VerifySource.directory #f))) c (? . 1)) ((c def c (c (? . 0) q Port (Port.Mode rhombus/annot))) c (? . 10)) ((c def c (c (? . 0) q Context (Context.Server #f))) c (? . 6)) ((c def c (c (? . 0) q is_available)) c (? . 7)) ((c def c (c (? . 0) q Listener (Listener.accept #f))) q (2677 . 5)) ((c def c (c (? . 0) q Context (Context.VerifyMode rhombus/annot))) c (? . 5)) ((c def c (c (? . 0) q connect)) q (1682 . 8)) ((c def c (c (? . 0) q Port (Port.Output rhombus/annot))) c (? . 8)) ((c def c (c (? . 0) q Context (Context.Server.set_server_alpn #f))) q (5406 . 6)) ((c def c (c (? . 0) q Context (Context.PrivateKey.pem #f))) c (? . 2)) ((c def c (c (? . 0) q Port (Port.selected_alpn #f))) q (1439 . 3)) ((c def c (c (? . 0) q Context (Context.PrivateKey.handle #f))) c (? . 2)) ((c def c (c (? . 0) q listen)) q (2320 . 9)) ((c def c (c (? . 0) q Context (Context.VerifyMode.try #f))) c (? . 5)) ((c def c (c (? . 0) q Listener (Listener.load_suggested_certificate_authorities #f))) c (? . 3)) ((c def c (c (? . 0) q Port (Port.addresses #f))) c (? . 9)) ((c def c (c (? . 0) q Port (Port.Mode.connect #f))) c (? . 10)) ((c def c (c (? . 0) q Listener (Listener.addresses #f))) q (2825 . 4)) ((c def c (c (? . 0) q Port (Port.Mode.accept #f))) c (? . 10)) ((c def c (c (? . 0) q Context (Context.load_suggested_certificate_authorities #f))) c (? . 11)) ((c def c (c (? . 0) q Context (Context.PrivateKey rhombus/annot))) c (? . 2)) ((c def c (c (? . 0) q Context (Context.set_ciphers #f))) q (5330 . 3)) ((c def c (c (? . 0) q Context (Context.Client #f))) c (? . 6)) ((c def c (c (? . 0) q Port (Port.set_verify #f))) q (946 . 5)) ((c def c (c (? . 0) q Context (Context.load_private_key #f))) c (? . 2)) ((c def c (c (? . 0) q Port (Port.from_ports #f))) c (? . 10)) ((c def c (c (? . 0) q Port (Port.peer_check_hostname #f))) q (1206 . 3)) ((c def c (c (? . 0) q Context (Context.set_verify_hostname #f))) c (? . 5)) ((c def c (c (? . 0) q Context (Context.VerifyMode.always #f))) c (? . 5)) ((c def c (c (? . 0) q Context (Context.Server rhombus/annot))) c (? . 6)) ((c def c (c (? . 0) q Context (Context.KeyKind.any #f))) c (? . 2)) ((c def c (c (? . 0) q Port (Port.is_peer_verified #f))) q (1047 . 3)) ((c def c (c (? . 0) q Port (Port.Input rhombus/annot))) c (? . 8))))
value

def ssl.is_available :: Boolean
 

def ssl.unavailable_reason :: maybe(String)
annotation

ssl.Port
 

ssl.Port.Input
 

ssl.Port.Output
function

fun ssl.Port.from_ports(
  in :: Port.Input,
  out :: Port.Output,
  ~mode: mode :: ssl.Port.Mode = #'connect,
  ~context: context :: ssl.Context = (if mode == #'connect
                                      | ssl.Context.Client()
                                      | ssl.Context.Server()),
  ~host: host :: maybe(String) = #false,
  ~alpn_protocols: alpn_protocols :: List.of(Bytes) = [],
  ~close_original: close_original = #false,
  ~shutdown_on_close: shutdown_on_close = #false,
  ~exn: exn :: (String, Continuation.Marks) -> Any = Exn.Fail
) :~ values(ssl.Port.Input, ssl.Port.Output)
 

enum ssl.Port.Mode:
  connect
  accept
method

method (port :: ssl.Port).set_verify(
  mode :: ssl.Context.VerifyMode = #'always
)
method

method (port :: ssl.Port).is_peer_verified() :: Boolean
method

method (port :: ssl.Port).peer_certificate_hostnames()
  :: List.of(String)
method

method (port :: ssl.Port).peer_check_hostname(host :: String) :: Boolean
method

method (port :: ssl.Port).peer_subject_name() :: maybe(Bytes)
 

method (port :: ssl.Port).peer_issuer_name() :: maybe(Bytes)
method

method (port :: ssl.Port).selected_alpn() :~ maybe(Bytes)
method

method (port :: ssl.Port).addresses()
  :: values(String, network.PortNumber, String, network.ListenPortNumber)
 

method (port :: ssl.Port).abandon()
function

fun ssl.connect(
  ~host: host :: String,
  ~port: port :: network.PortNumber,
  ~context: context :: ssl.Context.Client = ssl.Context.Client(),
  ~alpn_protcols: alpn_protocols :: List.of(Bytes) = []
) :~ values(ssl.Port.Input, ss.Port.Output)
class

class ssl.Listener():
  constructor (
    ~host: host :: maybe(String) = #false,
    ~port: port :: network.ListenPortNumber,
    ~context: context :: ssl.Context.Server = ssl.Context.Server(),
    ~reuse: reuse :: Any = #false,
    ~max_allow_wait: max_allow_wait :: Nat = 5,
  ) :~ ssl.Listener
function

fun ssl.listen(
  ~host: host :: maybe(String) = #false,
  ~port: port :: network.ListenPortNumber,
  ~context: context :: ssl.Context.Server = ssl.Context.Server(),
  ~reuse: reuse :: Any = #false,
  ~max_allow_wait: max_allow_wait :: Nat = 5,
) :~ ssl.Listener
method

method (lnr :: ssl.Listener).close()
method

method (lnr :: ssl.Listener).accept(
  ~wait: wait :: network.NetworkWait = #'all
) :: values(ssl.Port.Input, ssl.Port.Output)
method

method (lnr :: ssl.Listener).addresses()
  :: values(String, network.PortNumber)
method

method (lnr :: ssl.Listener).load_certificate_chain(
  path :: PathString
)
 

method (lnr :: ssl.Listener)
  .load_suggested_certificate_authorities(path :: PathString)
 

method (lnr :: ssl.Listener).load_private_key(
  key :: PathString || ssl.Context.PrivateKey,
  ~kind: kind :: ssl.Context.KeyKind = #'rsa
)
annotation

ssl.Context
 

ssl.Context.Client
 

ssl.Context.Server
 

fun ssl.Context.Client(~secure: secure = #true)
  :: ssl.Context.Client
 

fun ssl.Context.Server(
  ~private_key: private_key :: maybe(ssl.Context.PrivateKey) = #false,
  ~certificate_chain: certificate_chain :: maybe(Path) = #false
) :: ssl.Context.Server
method

method (ctx :: ssl.Context).load_verify_source(
  src :: PathString || ssl.Context.VerifySource
)
 

ssl.Context.VerifySource
 

fun ssl.Context.VerifySource.default()
  :: ssl.Context.VerifySource
 

fun ssl.Context.VerifySource.file(path :: PathString)
  :: ssl.Context.VerifySource
 

fun ssl.Context.VerifySource.directory(path :: PathString)
  :: ssl.Context.VerifySource
 

fun ssl.Context.VerifySource.win_store(bstr :: Bytes)
  :: ssl.Context.VerifySource
 

fun ssl.Context.VerifySource.mac_keychain(path :: maybe(PathString))
  :: ssl.Context.VerifySource
 

property (vs :: ssl.Context.VerifySource).handle
method

method (ctx :: ssl.Context).load_private_key(
  key :: PathString || ssl.Context.PrivateKey,
  ~kind: kind :: ssl.Context.KeyKind = #'rsa
)
 

ssl.Context.PrivateKey
 

fun ssl.Context.PrivateKey.pem(path :: PathString)
  :: ssl.Context.PrivateKey
 

fun ssl.Context.PrivateKey.pem_bytes(bstr :: Bytes)
  :: ssl.Context.PrivateKey
 

fun ssl.Context.PrivateKey.der(path :: PathString)
  :: ssl.Context.PrivateKey
 

property (vs :: ssl.Context.PrivateKey).handle
 

enum ssl.Context.KeyKind:
  rsa
  any
method

method (ctx :: ssl.Context).load_certificate_chain(
  path :: PathString
)
 

method (ctx :: ssl.Context)
  .load_suggested_certificate_authorities(path :: PathString)
method

method (ctx :: ssl.Context).set_verify(
  mode :: ssl.Context.VerifyMode = #'always
)
 

method (ctx :: ssl.Context).set_verify_hostname(
  mode :: ssl.Context.VerifyMode = #'always
)
 

enum ssl.Context.VerifyMode:
  never
  try
  always
method

method (ctx :: ssl.Context).set_ciphers(cipher_spec :: String)
method

method (ctx :: ssl.Context.Server).set_server_alpn(
  alpn_protocols :: List.of(Bytes),
  ~allow_no_match: allow_no_match = #true
) :: Void
method

method (ctx :: ssl.Context).seal() :: Void
