3183
((3) 0 () 14 ((q lib "net/cookie/user_agent.rhm") (q 1092 . 15) (q lib "net/cookie/server.rhm") (q 110 . 13) (q 1907 . 12) (q lib "net/cookie.rhm") (q Cookie.is_http_only #f) (q Cookie.handle #f) (q 1743 . 7) (q Cookie.domain #f) (q Cookie.value #f) (q Cookie.path #f) (q 3779 . 6) (q Cookie.name #f)) () (h ! (equal) ((c def c (c (? . 0) q Cookie (Cookie.from_handle #f))) c (? . 8)) ((c def c (c (? . 0) q parse (parse.parse_cookie #f))) q (3421 . 7)) ((c def c (c (? . 0) q CookieJar (CookieJar.save_cookie #f))) c (? . 4)) ((c def c (c (? . 0) q CookieJar (CookieJar.cookies_matching #f))) q (2521 . 6)) ((c def c (c (? . 2) c Cookie c (? . 9))) c (? . 3)) ((c def c (c (? . 0) c Cookie c (? . 6))) c (? . 1)) ((c def c (c (? . 0) q CookieJar (CookieJar.extract_and_save_cookies #f))) q (2260 . 7)) ((c def c (c (? . 0) q CookieJar (CookieJar.current #f))) q (3012 . 4)) ((c def c (c (? . 0) q CookieJar (CookieJar.handle #f))) q (3104 . 3)) ((c def c (c (? . 0) q Cookie (Cookie.is_persistent #f))) c (? . 1)) ((c def c (c (? . 0) q Cookie (Cookie.access_time #f))) c (? . 1)) ((c def c (c (? . 2) c Cookie c (? . 7))) q (1042 . 3)) ((c def c (c (? . 0) q Cookie (Cookie.is_host_only #f))) c (? . 1)) ((c def c (c (? . 0) q parse (parse.default_path #f))) q (3611 . 4)) ((c def c (c (? . 0) q Cookie)) c (? . 1)) ((c def c (c (? . 2) q Cookie (Cookie.extension #f))) c (? . 3)) ((c def c (c (? . 0) q CookieJar (CookieJar.save_cookies #f))) c (? . 4)) ((c def c (c (? . 0) q Cookie (Cookie.is_secure_only #f))) c (? . 1)) ((c def c (c (? . 5) q PathOrExtension rhombus/annot)) q (49 . 3)) ((c def c (c (? . 0) c Cookie c (? . 11))) c (? . 1)) ((c def c (c (? . 2) q Cookie (Cookie.max_age #f))) c (? . 3)) ((c def c (c (? . 0) q Cookie (Cookie.is_expired #f))) q (1635 . 5)) ((c def c (c (? . 5) q Domain rhombus/annot)) q (84 . 3)) ((c def c (c (? . 5) q Value rhombus/annot)) q (24 . 3)) ((c def c (c (? . 0) q parse (parse.extract_cookies #f))) q (3162 . 7)) ((c def c (c (? . 2) c Cookie c (? . 6))) c (? . 3)) ((c def c (c (? . 0) c Cookie c (? . 7))) c (? . 8)) ((c def c (c (? . 5) q Name rhombus/annot)) q (0 . 3)) ((c def c (c (? . 2) c Cookie c (? . 13))) c (? . 3)) ((c def c (c (? . 2) c Cookie c (? . 10))) c (? . 3)) ((c def c (c (? . 0) c Cookie c (? . 9))) c (? . 1)) ((c def c (c (? . 0) q Cookie (Cookie.expiration_time #f))) c (? . 1)) ((c def c (c (? . 2) q Cookie (Cookie.clear_string #f))) q (625 . 7)) ((c def c (c (? . 2) q Cookie (Cookie.header_to_map #f))) q (831 . 11)) ((c def c (c (? . 0) c Cookie c (? . 10))) c (? . 1)) ((c def c (c (? . 0) q Cookie (Cookie.creation_time #f))) c (? . 1)) ((c def c (c (? . 0) q CookieJar (CookieJar.cookie_header #f))) q (2703 . 8)) ((c def c (c (? . 2) c Cookie c (? . 11))) c (? . 3)) ((c def c (c (? . 2) q Cookie (Cookie.is_secure #f))) c (? . 3)) ((c def c (c (? . 2) q Cookie)) c (? . 3)) ((c def c (c (? . 0) q parse (parse.min_cookie_seconds #f))) c (? . 12)) ((c def c (c (? . 0) q parse (parse.max_cookie_seconds #f))) c (? . 12)) ((c def c (c (? . 0) c Cookie c (? . 13))) c (? . 1)) ((c def c (c (? . 0) q parse (parse.parse_date #f))) q (3685 . 4)) ((c def c (c (? . 0) q CookieJar)) q (1870 . 3))))
annotation

cookie.Name
annotation

cookie.Value
annotation

cookie.PathOrExtension
annotation

cookie.Domain
class

class server.Cookie(
  name :: cookie.Name,
  value :: cookie.Value,
  ~exp_date: exp_date :: maybe(date.ZonedDateTime) = #false,
  ~max_age: max_age :: maybe(PosInt) = #false,
  ~domain: domain :: maybe(cookie.Domain) = #false,
  ~path: path :: maybe(cookie.PathOrExtension) = #false,
  ~extension: extension :: maybe(cookie.PathOrExtension) = #false,
  ~is_secure: is_secure :: Boolean = #false,
  ~is_http_only: is_http_only :: Boolean = #false
)
function

fun server.Cookie.clear_string(
  name :: cookie.Name,
  ~domain: domain :: maybe(cookie.Domain) = #false,
  ~path: path :: maybe(cookie.PathOrExtension) = #false
) :: String
function

fun server.Cookie.header_to_map(
  header :: Bytes,
) :: Map.of(Bytes, Bytes)
 

fun server.Cookie.header_to_map(
  header :~ Bytes,
  ~decode: decode :: (Bytes -> Any)
) :: Map
property

property (c :: server.Cookie).handle
class

class user_agent.Cookie(
  name :: cookie.Name,
  value :: cookie.Value,
  ~domain: domain :: cookie.Domain,
  ~path: path :: cookie.PathOrExtension,
  ~expiration_time: expiration_time :: PosInt,
  ~creation_time: creation_time :: PosInt,
  ~access_time: access_time :: PosInt,
  ~is_persistent: is_persistent :: Any.to_boolean,
  ~is_host_only: is_host_only :: Any.to_boolean,
  ~is_secure_only: is_secure_only :: Any.to_boolean,
  ~is_http_only: is_http_only :: Any.to_boolean
)
method

method (c :: user_agent.Cookie).is_expired(
  now :: Int = system.seconds()
) :: Boolean
property

property (c :: user_agent.Cookie).handle
 

fun user_agent.Cookie.from_handle(handle)
  :: user_agent.Cookie
class

class user_agent.CookieJar()
method

method (cj :: user_agent.CookieJar).save_cookie(
  cookie :: user_agent.Cookie,
  ~via_http: via_http :: Any.to_boolean = #true
) :: Void
 

method (cj :: user_agent.CookieJar).save_cookies(
  cookies :: Listable.to_list && List.of(user_agent.Cookie),
  ~via_http: via_http :: Any.to_boolean = #true
) :: Void
method

method (cj :: user_agent.CookieJar).extract_and_save_cookies(
  headers :: Map.of(String, Bytes) || (Listable.to_list && List.of(Bytes)),
  ~url: url :: URL,
  ~decode: decode :: Bytes -> String = Bytes.utf8_string
) :: Void
method

method (cj :: user_agent.CookieJar).cookies_matching(
  url :: URL,
  ~is_secure :: is_secure = (URL.scheme(url) == "https")
) :: List.of(user_agent.Cookie)
method

method (cj :: user_agent.CookieJar).cookie_header(
  url :: URL,
  ~encode: encode :: String -> Bytes = String.utf8_bytes,
  ~keep: keep :: user_agent.Cookie -> Any = fun (x): #true,
  ~skip: skip :: user_agent.Cookie -> Any = fun (x): #false
) :: maybe(Bytes)
context parameter

Parameter.def user_agent.CookieJar.current
  :: user_agent.CookieJar
property

property (cj :: user_agent.CookieJar).handle
function

fun user_agent.parse.extract_cookies(
  headers :: Map.of(String, Bytes) || (Listable.to_list && List.of(Bytes)),
  ~url: url :: URL,
  ~decode: decode :: Bytes -> String = Bytes.utf8_string
) :: List.of(user_agent.Cookie)
function

fun user_agent.parse.parse_cookie(
  bstr :: Bytes,
  ~url: url :: URL,
  ~decode: decode :: Bytes -> String = Bytes.utf8_string
) :: maybe(user_agent.Cookie)
function

fun user_agent.parse.default_path(url :: URL)
  :: String
function

fun user_agent.parse.parse_date(str :: String)
  :: maybe(date.ZonedDateTime)
value

def user_agent.parse.min_cookie_seconds
 

def user_agent.parse.max_cookie_seconds
