3468
((3) 0 () 11 ((q lib "net/http.rhm") (q 0 . 35) (q 2796 . 15) (q 2248 . 10) (q 1022 . 12) (q 4707 . 21) (q 4295 . 8) (q 3185 . 6) (q 3368 . 6) (q 5339 . 8) (q 5491 . 10)) () (h ! (equal) ((c def c (c (? . 0) q LiteralURL (LiteralURL.to_string #f))) c (? . 9)) ((c def c (c (? . 0) q current_user_agent)) q (3497 . 3)) ((c def c (c (? . 0) q Method rhombus/annot)) c (? . 3)) ((c def c (c (? . 0) q Response (Response.status_code #f))) c (? . 2)) ((c def c (c (? . 0) q Response (Response.history #f))) q (3298 . 3)) ((c def c (c (? . 0) q auth (auth.Function rhombus/annot))) q (3610 . 3)) ((c def c (c (? . 0) q payload (payload.form #f))) q (3975 . 3)) ((c def c (c (? . 0) q options)) c (? . 1)) ((c def c (c (? . 0) q post)) c (? . 1)) ((c def c (c (? . 0) q Response (Response.output #f))) c (? . 7)) ((c def c (c (? . 0) q Response (Response.raw_headers #f))) c (? . 2)) ((c def c (c (? . 0) q patch)) c (? . 1)) ((c def c (c (? . 0) q Method (Method.head #f))) c (? . 3)) ((c def c (c (? . 0) q payload (payload.Function rhombus/annot))) q (3867 . 3)) ((c def c (c (? . 0) q Session)) c (? . 4)) ((c def c (c (? . 0) q Response (Response.status_line #f))) c (? . 2)) ((c def c (c (? . 0) q Proxy (Proxy.http #f))) c (? . 5)) ((c def c (c (? . 0) q Session (Session.request #f))) q (1403 . 16)) ((c def c (c (? . 0) q Session (Session.close #f))) c (? . 4)) ((c def c (c (? . 0) q delete)) c (? . 1)) ((c def c (c (? . 0) q payload (payload.json #f))) q (4055 . 3)) ((c def c (c (? . 0) q Exn (Exn.Fail.HTTP rhombus/class))) c (? . 10)) ((c def c (c (? . 0) q auth (auth.bearer #f))) q (3781 . 5)) ((c def c (c (? . 0) q Headers rhombus/annot)) q (2342 . 3)) ((c def c (c (? . 0) q payload (payload.buffered #f))) q (3896 . 3)) ((c def c (c (? . 0) q Proxy (Proxy.https #f))) c (? . 5)) ((c def c (c (? . 0) q Timeouts (Timeouts._handle #f))) c (? . 6)) ((c def c (c (? . 0) q payload (payload.pure #f))) q (4198 . 4)) ((c def c (c (? . 0) q Method (Method.get #f))) c (? . 3)) ((c def c (c (? . 0) q Proxy)) c (? . 5)) ((c def c (c (? . 0) q Response rhombus/annot)) q (2362 . 14)) ((c def c (c (? . 0) q payload (payload.gzip #f))) q (4123 . 3)) ((c def c (c (? . 0) q head)) c (? . 1)) ((c def c (c (? . 0) q Response (Response.headers #f))) q (3110 . 3)) ((c def c (c (? . 0) q StatusCode rhombus/annot)) q (3474 . 3)) ((c def c (c (? . 0) q Method (Method.post #f))) c (? . 3)) ((c def c (c (? . 0) q Method (Method.put #f))) c (? . 3)) ((c def c (c (? . 0) q Method (Method.patch #f))) c (? . 3)) ((c def c (c (? . 0) q get)) c (? . 1)) ((c def c (c (? . 0) q Timeouts)) c (? . 6)) ((c def c (c (? . 0) q Response (Response.body #f))) c (? . 7)) ((c def c (c (? . 0) q Response (Response.drain #f))) c (? . 8)) ((c def c (c (? . 0) q auth (auth.basic #f))) q (3636 . 6)) ((c def c (c (? . 0) q Response (Response.close #f))) c (? . 8)) ((c def c (c (? . 0) q PoolConfig)) q (4511 . 7)) ((c def c (c (? . 0) q Method (Method.delete #f))) c (? . 3)) ((c def c (c (? . 0) q put)) c (? . 1)) ((c def c (c (? . 0) q Response (Response.status_message #f))) c (? . 2)) ((c def c (c (? . 0) q LiteralURL)) c (? . 9)) ((c def c (c (? . 0) q Exn (Exn.Fail.HTTP.Timeout.kind #f))) c (? . 10)) ((c def c (c (? . 0) q Session (Session.current #f))) q (2185 . 3)) ((c def c (c (? . 0) q Method (Method.options #f))) c (? . 3)) ((c def c (c (? . 0) q Response (Response.handle #f))) q (3562 . 3)) ((c def c (c (? . 0) q Response (Response.http_version #f))) c (? . 2))))
function

fun get(
  uri :: Bytes || String || url.URL || LiteralURL,
  ~session: session :: Session = Session.current(),
  ~method: method :: Method = #'get,
  ~close: close :: Any.to_boolean = #false,
  ~stream: stream :: Any.to_boolean = #false,
  ~headers: headers :: Headers = {},
  ~params: params :: List.of(url.KeyValue) = [],
  ~auth: auth :: maybe(auth.Function) = #false,         
  ~data: data :: maybe(Bytes || String || Port.Input || payload.Function) = #false,
  ~timeouts: timeouts :: Timeouts = Timeouts(),
  ~max_attempts: max_attempts :: PosInt = 3,
  ~max_redirects: max_redirects :: PosInt = 16,
  ~user_agent: user_agent :: Bytes || String = current_user_agent()
) :: Response
 

fun post(....) :: Response
 

fun delete(....) :: Response
 

fun head(....) :: Response
 

fun options(....) :: Response
 

fun patch(....) :: Response
 

fun put(....) :: Response
class

class Session():
  constructor (
    ~pool_config: pool_config :: PoolConfig = PoolConfig(),
    ~ssl_context: context :: maybe(ssl.Context.Client) = ssl.Context.Client(),
    ~cookie_jar: cookie_jar :: maybe(CookieJar) = #false,
    ~proxies: proxies :: List.of(Proxy) = []
  )
 

method (session :: Session).close() :: Void
method

method (session :: Session).request(
  uri :: Bytes || String || url.URL || LiteralURL,
  ~method: method :: Method = #'get,
  ~close: close :: Any.to_boolean = #false,
  ~stream: stream :: Any.to_boolean = #false,
  ~headers: headers :: Headers = {},
  ~params: params :: List.of(url.KeyValue) = [],
  ~auth: auth :: maybe(auth.Function) = #false,         
  ~data: data :: maybe(Bytes || String || Port.Input || payload.Function) = #false,
  ~timeouts: timeouts :: Timeouts = Timeouts(),
  ~max_attempts: max_attempts :: PosInt = 3,
  ~max_redirects: max_redirects :: PosInt = 16,
  ~user_agent: user_agent :: Bytes || String = current_user_agent()
) :: Response
context parameter

Parameter.def Session.current :: Session
enumeration

enum Method:
  get
  post
  delete
  head
  options
  patch
  put
annotation

Headers
class

class Response():
  expression ~none
  binding 'Response($field, ...)'
 
field = ~status_line: bstr_bind
      | ~status_code: status_code_bind
      | ~status_message: bstr_bind
      | ~http_version: bstr_bind
      | ~history: response_list_bind
      | ~headers: { key_str: bstr_bind, ... }
      | ~headers: { key_str: bstr_bind, ..., & bstr_list_bind }
      | ~body: bstr_bind
property

property (resp :: Response).status_line :: Bytes
 

property (resp :: Response).status_code :: StatusCode
 

property (resp :: Response).status_message :: Bytes
 

property (resp :: Response).http_version :: Bytes
 

property (resp :: Response).raw_headers :: List.of(Bytes)
method

method (resp :: Response).headers() :: Map.of(String, Bytes)
method

method (resp :: Response).output() :: Port.Input
 

method (resp :: Response).body() :: Bytes
method

method (resp :: Response).history() :: List.of(Response)
method

method (resp :: Response).close() :: Void
 

method (resp :: Response).drain() :: Void
annotation

StatusCode
context parameter

Parameter.def current_user_agent :: String
property

property (resp :: Response).handle
annotation

auth.Function
function

fun auth.basic(
  ~username: username :: String || Bytes,
  ~password: password :: String || Bytes
) :: auth.Function
function

fun auth.bearer(
  ~token: token :: String || Bytes
) :: Function
annotation

payload.Function
function

fun payload.buffered(f :: payload.Function) :: payload.Function
function

fun payload.form(v :: List.of(url.KeyValue)) :: payload.Function
function

fun payload.json(v :: json.JSON) :: payload.Function
function

fun payload.gzip(f :: payload.Function) :: payload.Function
function

fun payload.pure(inp :: Bytes || String || Port.Input)
  :: payload.Function
class

class Timeouts(_handle):
  constructor (
    ~lease: lease :: maybe(PosReal) = 5,
    ~connect: connect :: maybe(PosReal) = 5,
    ~request: request :: maybe(PosReal) = 30
  )
class

class PoolConfig():
  constructor (
    ~max_size: max_size :: PosInt || matching(#inf) = 128,
    ~idle_timeout_seconds: idle_timeout :: maybe(PosReal) = 600
  )
class

class Proxy():
  constructor (
    ~matches: matches :: url.URL -> Boolean,
    ~connect: connect :: (HTTPConn, url.URL, maybe(SSLContext)) -> Void
  )
 

fun Proxy.http(
  ~proxy_url: proxy_url :: String || Bytes || url.URL,
  ~matches: matches :: url.URL -> Boolean:
              fun (u :: url.URL): u.scheme == "http"
) :: Proxy
 

fun Proxy.https(
  ~proxy_url: proxy_url :: String || Bytes || url.URL,
  ~matches: matches :: url.URL -> Boolean:
              = fun (u :: url.URL): u.scheme == "https"
) :: Proxy
class

class LiteralURL():
  constructor (s :: String):
    super(easy.#{string->url/literal})
 

method LiteralURL.to_string() :: String
veneer

veneer Exn.Fail.HTTP
 

veneer Exn.Fail.HTTP
 

property (exn :: Exn.Fail.HTTP.Timeout).kind
  :: Any.of(#'lease, #'connect, #'request)
