// Autogenerated by `scribblings/main/private/local-redirect'
//  This script is included by generated documentation to rewrite
//  links expressed as tag queries into local-filesystem links.

var link_dirs = [
 ["compatibility", "../compatibility"],
 ["continue", "../continue"],
 ["cookies", "../cookies"],
 ["data", "../data"],
 ["db", "../db"],
 ["demo-m1", "../demo-m1"],
 ["demo-m2", "../demo-m2"],
 ["demo-manual-m1", "../demo-manual-m1"],
 ["demo-manual-m2", "../demo-manual-m2"],
 ["demo-manual-s1", "../demo-manual-s1"],
 ["demo-manual-s2", "../demo-manual-s2"],
 ["demo-s1", "../demo-s1"],
 ["demo-s2", "../demo-s2"],
 ["distributed-places", "../distributed-places"],
 ["draw", "../draw"],
 ["drracket", "../drracket"],
 ["dynext", "../dynext"],
 ["embedded-gui", "../embedded-gui"],
 ["enforest", "../enforest"],
 ["errortrace", "../errortrace"],
 ["file", "../file"],
 ["foreign", "../foreign"],
 ["framework", "../framework"],
 ["future-visualizer", "../future-visualizer"],
 ["getting-started", "../getting-started"],
 ["gui", "../gui"],
 ["gui-easy", "../gui-easy"],
 ["guide", "../guide"],
 ["help", "../help"],
 ["http-easy", "../http-easy"],
 ["inside", "../inside"],
 ["json", "../json"],
 ["macro-debugger", "../macro-debugger"],
 ["math", "../math"],
 ["more", "../more"],
 ["mrlib", "../mrlib"],
 ["mzlib", "../mzlib"],
 ["mzscheme", "../mzscheme"],
 ["net", "../net"],
 ["openssl", "../openssl"],
 ["osx-ssl", "../osx-ssl"],
 ["pconvert", "../pconvert"],
 ["pict", "../pict"],
 ["pkg", "../pkg"],
 ["planet", "../planet"],
 ["plot", "../plot"],
 ["pretty-expressive", "../pretty-expressive"],
 ["profile", "../profile"],
 ["quick", "../quick"],
 ["r5rs", "../r5rs"],
 ["r6rs", "../r6rs"],
 ["rackunit", "../rackunit"],
 ["raco", "../raco"],
 ["readline", "../readline"],
 ["reference", "../reference"],
 ["rhombus", "../rhombus"],
 ["rhombus-draw", "../rhombus-draw"],
 ["rhombus-getting-started", "../rhombus-getting-started"],
 ["rhombus-gui", "../rhombus-gui"],
 ["rhombus-http", "../rhombus-http"],
 ["rhombus-json", "../rhombus-json"],
 ["rhombus-logo", "../rhombus-logo"],
 ["rhombus-meta", "../rhombus-meta"],
 ["rhombus-meta-tutorial", "../rhombus-meta-tutorial"],
 ["rhombus-model", "../rhombus-model"],
 ["rhombus-net-cookie", "../rhombus-net-cookie"],
 ["rhombus-pict", "../rhombus-pict"],
 ["rhombus-racket", "../rhombus-racket"],
 ["rhombus-reference", "../rhombus-reference"],
 ["rhombus-scribble", "../rhombus-scribble"],
 ["rhombus-slideshow", "../rhombus-slideshow"],
 ["rhombus-ssl", "../rhombus-ssl"],
 ["rhombus-url", "../rhombus-url"],
 ["rhombus-xml", "../rhombus-xml"],
 ["scheme", "../scheme"],
 ["scribble", "../scribble"],
 ["scribble-pp", "../scribble-pp"],
 ["scriblib", "../scriblib"],
 ["shrubbery", "../shrubbery"],
 ["simple-tree-text-markup", "../simple-tree-text-markup"],
 ["slideshow", "../slideshow"],
 ["source-syntax", "../source-syntax"],
 ["srfi", "../srfi"],
 ["string-constants", "../string-constants"],
 ["style", "../style"],
 ["syntax", "../syntax"],
 ["syntax-color", "../syntax-color"],
 ["tools", "../tools"],
 ["ts-guide", "../ts-guide"],
 ["ts-reference", "../ts-reference"],
 ["version", "../version"],
 ["version-case", "../version-case"],
 ["web-server", "../web-server"],
 ["web-server-internal", "../web-server-internal"],
 ["win32-ssl", "../win32-ssl"],
 ["xml", "../xml"],
 ["xrepl", "../xrepl"]];

function bsearch(str, a, start, end) {
   if (start >= end)
     return false;
   else {
     var mid = Math.floor((start + end) / 2);
     if (a[mid][0] == str)
       return mid;
     else if (a[mid][0] < str)
       return bsearch(str, a, mid+1, end);
     else
       return bsearch(str, a, start, mid);
   }
}

var link_target_prefix = false;

function hash_string(s) {
   var v = 0;
   for (var i = 0; i < s.length; i++) {
     v = (((v << 5) - v) + s.charCodeAt(i)) & 0xFFFFFF;
   }
   return v;
}

function demand_load(p, callback) {
   // Based on a StackOverflow answer, which cites:
   // JavaScript Patterns, by Stoyan Stefanov (O’Reilly). Copyright 2010 Yahoo!, Inc., 9780596806750.
   var script = document.getElementsByTagName('script')[0];
   var newjs = document.createElement('script');
   newjs.src = p;
   if (callback) {
      // IE
      newjs.onreadystatechange = function () {
          if (newjs.readyState === 'loaded' || newjs.readyState === 'complete') {
            newjs.onreadystatechange = null;
            callback();
          }
        };
      // others
      newjs.onload = callback;
   }
   script.parentNode.appendChild(newjs);
}

var loaded_link_targets = [];
var link_targets = [];
var num_link_target_bins = 7;

function convert_all_links() {
   var elements = document.getElementsByClassName("Sq");
   for (var i = 0; i < elements.length; i++) {
     var elem = elements[i];
     var tag = elem.href.match(/tag=[^&]*/);
     var doc = elem.href.match(/doc=[^&]*/);
     var rel = elem.href.match(/rel=[^&]*/);
     if (doc && rel) {
         var pos = bsearch(decodeURIComponent(doc[0].substring(4)),
                                     link_dirs,
                                     0,
                                     link_dirs.length);
         if (pos) {
           var p = link_dirs[pos][1];
           if (link_target_prefix) {
             p = link_target_prefix + p;
           }
           elem.href = p + "/" + decodeURIComponent(rel[0].substring(4));
           tag = false;
         }
     }
     if (tag) {
       var v = hash_string(decodeURIComponent(tag[0].substring(4))) % 7;
       if (!loaded_link_targets[v]) {
         loaded_link_targets[v] = true;
         var p = "../local-redirect/local-redirect_" + v + ".js";
         if (link_target_prefix) {
           p = link_target_prefix + p;
         }
         demand_load(p, false);
       }
     }
  }
}

AddOnLoad(convert_all_links);
