#lang racket/base

(require (for-syntax racket/base
                     syntax/parse
                     "../version-misc.rkt"))

(provide (for-syntax (all-from-out "../version-misc.rkt"))
         version-case)

(define-syntax (version-case stx)
  (syntax-parse stx
    [(_ [test code ...] ... [{~datum else} last-code ...])
     #:with name (syntax/loc stx the-macro)
     #:with transformer
     (syntax/loc stx
       (lambda (stx*)
         (cond [test
                (syntax-local-introduce
                 (quote-syntax (begin code ...)))]
               ...
               [else
                (syntax-local-introduce
                 (quote-syntax (begin last-code ...)))])))

     (case (syntax-local-context)
       [(expression)
        (syntax/loc stx
          (let-syntax ([name transformer])
            (name)))]
       [else
        (syntax/loc stx
          (begin
            (define-syntax name transformer)
            (name)))])]
    [(_ [test code ...] ...)
     (syntax/loc stx
       (version-case [test code ...]
                     ...
                     [else (void)]))]))
