#lang racket/base

(module+ test
  (require rackunit
           version-case
           (for-syntax racket/base)
           (for-template version-case))


  (check-true (version< "1.2.3" "1.19.4"))
  (check-false (version< "1.2.3" "1.1.4"))
  (check-true (version< "1.2" "1.3"))
  (check-false (version< "1.2" "1.1"))
  (check-true (version< "1.2" "1.2.5"))
  (check-false (version< "1.2.5" "1.2"))

  (check-true (version< "300" "301"))
  (check-false (version< "300" "299"))
  (check-true (version< "300.1" "300.2"))
  (check-false (version< "300.2" "300.1"))
  (check-true (version< "300" "300.2"))
  (check-false (version< "300.2" "300"))

  ;; Small test code to see that we can write unit-dependent code
  ;; that still runs under both 360 and 369.

  ;; version-case should be usable in expression position
  (printf "~s~n" (version-case [(version= (version) "360")
                                "360"]
                               [else
                                "something else"]))
  (printf "~s~n" (version-case [(version= (version) "360")
                                "360"]))


  ;; Ellipses should work in a version case.
  (printf "~s~n"
          (map syntax-e (syntax->list
                         (version-case
                          (#f blah)
                          (else
                           (syntax-case (syntax (foo bar)) ()
                             [(x ...)
                              (syntax (x ...))]))))))
  ;; we expect '(foo bar)


  (version-case
   [(version<= (version) "360")
    (printf "old unit code~n")
    (require (lib "mred.ss" "mred")
             (lib "tool.ss" "drscheme")
             (lib "unitsig.ss"))

    (define tool@
      (unit/sig drscheme:tool-exports^
          (import drscheme:tool^)
        (define (phase1)
          (message-box "phase1"))
        (define (phase2)
          (message-box "phase2"))))]

   [else
    (printf "new unit code~n")
    (require scheme/gui/base
             (lib "tool.ss" "drscheme")
             (lib "unit.ss"))
    (define-unit tool@
      (import drscheme:tool^)
      (export drscheme:tool-exports^)
      (define (phase1)
        (message-box "phase1"))
      (define (phase2)
        (message-box "phase2")))])

  (version-case
   [(version<= (version) "360")
    (printf "old unit code (no else form)~n")
    (require (lib "mred.ss" "mred")
             (lib "tool.ss" "drscheme")
             (lib "unitsig.ss"))

    (define tool2@
      (unit/sig drscheme:tool-exports^
          (import drscheme:tool^)
        (define (phase1)
          (message-box "phase1"))
        (define (phase2)
          (message-box "phase2"))))])

  (version-case
   [(version> (version) "360")
    (printf "new unit code (no else form)~n")
    (require scheme/gui/base
             (lib "tool.ss" "drscheme")
             (lib "unit.ss"))
    (define-unit tool2@
      (import drscheme:tool^)
      (export drscheme:tool-exports^)
      (define (phase1)
        (message-box "phase1"))
      (define (phase2)
        (message-box "phase2")))])

  (version-case
   [#t (require racket/function)])

  (println curry))
