#lang rhombus/scribble/manual
@(import:
    "common.rhm" open
    meta_label:
      rhombus/doc open)

@title{Documentation Metadata}

@docmodule(~use_sources: lib("rhombus/doc.rhm"),
           rhombus/doc)

The @rhombusmodname(rhombus/doc) module re-exports all of
@rhombuslangname(rhombus) and adds @rhombus(DocSpec, ~annot). The
@rhombusmodname(rhombus/doc) module is intended in part as a submodule
language for a splice that is generated by @rhombus(~doc) in forms such
as @rhombus(fun) or @rhombus(enum). The content of a
@rhombus(DocSpec, ~annot) is intended for use by external tools such as
Rhombus Scribble.

@doc(
  class DocSpec(headers :: List.of(Syntax),
                content :: List.of(Syntax))
){

 Each element of @rhombus(headers) represents part of a declaration as
 useful to show in documentation, such as the arguments and result of a
 function, but not the function's implementation. These syntax objects
 are meant to have no bindings, but they have source location and layout
 information to reconstruct the original text of the declaration.

 The @rhombus(content) list supplies a prose description the binding(s)
 in @rhombus(headers). The @rhombus(DocSpec) form makes no requirement on
 the shape of each element in @rhombus(content), but the intent is that
 is suitable for use in a Rhombus Scribble document.

}
