16701
((3) 0 () 42 ((q lib "rhombus/draw.rhm") (q 9614 . 31) (q 7851 . 15) (q 350 . 35) (q 1187 . 18) (q 4538 . 20) (q 17197 . 21) (q 10294 . 11) (q 6896 . 15) (q 16646 . 26) (q 10488 . 16) (q 16421 . 15) (q 14177 . 12) (q 4225 . 6) (q 13091 . 37) (q 14872 . 24) (q 16206 . 15) (q 4374 . 6) (q 10807 . 5) (q 5702 . 12) (q 8503 . 15) (q 11148 . 36) (q 10420 . 6) (q 6557 . 18) (q 1776 . 52) (q 7156 . 6) (q 7089 . 6) (q 12141 . 12) (q 11009 . 6) (q 10707 . 7) (q 7567 . 13) (q 30 . 6) (q 4916 . 5) (q 4303 . 6) (q 136 . 9) (q 1613 . 11) (q 12514 . 9) (q 4445 . 5) (q 8109 . 14) (q 12679 . 14) (q 6075 . 6) (q 12426 . 5)) () (h ! (equal) ((c def c (c (? . 0) q Font (Font.style #f))) c (? . 1)) ((c def c (c (? . 0) q Pen (Pen.Join rhombus/annot))) c (? . 25)) ((c def c (c (? . 0) q Font (Font.kind #f))) c (? . 1)) ((c def c (c (? . 0) q Brush (Brush.Style.panel #f))) c (? . 2)) ((c def c (c (? . 0) q Brush (Brush.Style.xor #f))) c (? . 2)) ((c def c (c (? . 0) q Region)) q (10871 . 4)) ((c def c (c (? . 0) q DC (DC.transformation #f))) c (? . 3)) ((c def c (c (? . 0) q Bitmap (Bitmap.width #f))) c (? . 15)) ((c def c (c (? . 0) q Pen (Pen.Cap.butt #f))) c (? . 26)) ((c def c (c (? . 0) q Path (Path.translate #f))) c (? . 12)) ((c def c (c (? . 0) q Path (Path.text_outline #f))) c (? . 14)) ((c def c (c (? . 0) q Font (Font.Weight.ultrabold #f))) c (? . 10)) ((c def c (c (? . 0) q Point (Point.x #f))) c (? . 16)) ((c def c (c (? . 0) q DC (DC.TextCombine.grapheme #f))) c (? . 17)) ((c def c (c (? . 0) q RadialGradient (RadialGradient.stops #f))) c (? . 20)) ((c def c (c (? . 0) q Transformation (Transformation.translate #f))) c (? . 6)) ((c def c (c (? . 0) q Font (Font.Kind.swiss #f))) c (? . 7)) ((c def c (c (? . 0) q PagedDC rhombus/class)) q (4503 . 3)) ((c def c (c (? . 0) q DC (DC.transform #f))) c (? . 4)) ((c def c (c (? . 0) q DC (DC.smoothing #f))) c (? . 3)) ((c def c (c (? . 0) q DC (DC.translate #f))) c (? . 4)) ((c def c (c (? . 0) q PagedDC (PagedDC.end #f))) c (? . 5)) ((c def c (c (? . 0) q PagedDC (PagedDC.start_page #f))) c (? . 5)) ((c def c (c (? . 0) q Brush (Brush.Style.fdiagonal_hatch #f))) c (? . 2)) ((c def c (c (? . 0) q Font (Font.FeatureString rhombus/annot))) q (10258 . 3)) ((c def c (c (? . 0) q DC (DC.Smoothing.smoothed #f))) c (? . 13)) ((c def c (c (? . 0) q Pen (Pen.Style.xor_short_dot #f))) c (? . 8)) ((c def c (c (? . 0) q Transformation (Transformation.y0 #f))) c (? . 6)) ((c def c (c (? . 0) q Font (Font.Smoothing.smoothed #f))) c (? . 29)) ((c def c (c (? . 0) q DC (DC.clear #f))) q (298 . 3)) ((c def c (c (? . 0) q Color)) q (5484 . 7)) ((c def c (c (? . 0) q Font (Font.Kind.script #f))) c (? . 7)) ((c def c (c (? . 0) q DC (DC.Fill.winding #f))) c (? . 37)) ((c def c (c (? . 0) q Pen (Pen.Style.xor_long_dot #f))) c (? . 8)) ((c def c (c (? . 0) q Transformation (Transformation.x0 #f))) c (? . 6)) ((c def c (c (? . 0) q Rect (Rect.zero #f))) c (? . 9)) ((c def c (c (? . 0) q DC (DC.from_handle #f))) c (? . 31)) ((c def c (c (? . 0) q Rect)) c (? . 9)) ((c def c (c (? . 0) q Size (Size.height #f))) c (? . 11)) ((c def c (c (? . 0) q DC (DC.font #f))) c (? . 3)) ((c def c (c (? . 0) q Font (Font.Kind.decorative #f))) c (? . 7)) ((c def c (c (? . 0) q Region (Region.rounded_rectangle #f))) c (? . 21)) ((c def c (c (? . 0) q Region (Region.contains #f))) c (? . 28)) ((c def c (c (? . 0) q Font (Font.Weight.semilight #f))) c (? . 10)) ((c def c (c (? . 0) q Bitmap (Bitmap.make_dc #f))) q (15333 . 3)) ((c def c (c (? . 0) q Font (Font.Weight.thin #f))) c (? . 10)) ((c def c (c (? . 0) q Font (Font.Kind rhombus/annot))) c (? . 7)) ((c def c (c (? . 0) q Brush (Brush.Style.hilite #f))) c (? . 2)) ((c def c (c (? . 0) q DC (DC.restore #f))) c (? . 35)) ((c def c (c (? . 0) q Pen (Pen.color #f))) c (? . 23)) ((c def c (c (? . 0) q SizeLike (SizeLike.to_size #f))) c (? . 11)) ((c def c (c (? . 0) q Pen (Pen.Style.solid #f))) c (? . 8)) ((c def c (c (? . 0) q Path (Path.rotate #f))) c (? . 12)) ((c def c (c (? . 0) q DC (DC.Smoothing.aligned #f))) c (? . 13)) ((c def c (c (? . 0) q Font (Font.Kind.roman #f))) c (? . 7)) ((c def c (c (? . 0) q Path (Path.polygon #f))) c (? . 14)) ((c def c (c (? . 0) q Rect (Rect.size #f))) c (? . 9)) ((c def c (c (? . 0) q Brush (Brush.style #f))) c (? . 30)) ((c def c (c (? . 0) q Bitmap (Bitmap.size #f))) c (? . 15)) ((c def c (c (? . 0) q Point (Point.y #f))) c (? . 16)) ((c def c (c (? . 0) q Bitmap)) q (14621 . 9)) ((c def c (c (? . 0) q Transformation (Transformation.rotate #f))) c (? . 6)) ((c def c (c (? . 0) q Font (Font.Hinting rhombus/annot))) c (? . 18)) ((c def c (c (? . 0) q Brush (Brush.Style.transparent #f))) c (? . 2)) ((c def c (c (? . 0) q Font (Font.Weight.normal #f))) c (? . 10)) ((c def c (c (? . 0) q Font (Font.Weight rhombus/annot))) c (? . 10)) ((c def c (c (? . 0) q PagedDC (PagedDC.end_doc #f))) c (? . 5)) ((c def c (c (? . 0) q Color (Color.green #f))) c (? . 19)) ((c def c (c (? . 0) q Region (Region.intersect #f))) c (? . 27)) ((c def c (c (? . 0) q LayeredTransformation rhombus/annot)) q (17788 . 3)) ((c def c (c (? . 0) q DC (DC.font_metrics_key #f))) q (4163 . 3)) ((c def c (c (? . 0) q Font (Font.Kind.modern #f))) c (? . 7)) ((c def c (c (? . 0) q DC (DC.BitmapOverlay rhombus/annot))) c (? . 33)) ((c def c (c (? . 0) q DC (DC.TextCombine.char #f))) c (? . 17)) ((c def c (c (? . 0) q PointLike (PointLike.to_point rhombus/annot))) c (? . 16)) ((c def c (c (? . 0) q PaperSize rhombus/annot)) c (? . 32)) ((c def c (c (? . 0) q DC (DC.polygon #f))) c (? . 24)) ((c def c (c (? . 0) q Transformation (Transformation.scale #f))) c (? . 6)) ((c def c (c (? . 0) q Font (Font.Style.normal #f))) c (? . 22)) ((c def c (c (? . 0) q LinearGradient)) c (? . 38)) ((c def c (c (? . 0) q Font (Font.Hinting.unaligned #f))) c (? . 18)) ((c def c (c (? . 0) q Color (Color.blue #f))) c (? . 19)) ((c def c (c (? . 0) q RadialGradient)) c (? . 20)) ((c def c (c (? . 0) q Bitmap (Bitmap.set_argb_pixels #f))) q (15656 . 9)) ((c def c (c (? . 0) q Region (Region.rectangle #f))) c (? . 21)) ((c def c (c (? . 0) q Font (Font.in_pixels #f))) c (? . 1)) ((c def c (c (? . 0) q Font (Font.Style.slant #f))) c (? . 22)) ((c def c (c (? . 0) q DC (DC.rotate #f))) c (? . 4)) ((c def c (c (? . 0) q Pen (Pen.Style rhombus/annot))) c (? . 8)) ((c def c (c (? . 0) q Font (Font.Weight.light #f))) c (? . 10)) ((c def c (c (? . 0) q Font (Font.Weight.bold #f))) c (? . 10)) ((c def c (c (? . 0) q DC (DC.height #f))) c (? . 34)) ((c def c (c (? . 0) q Pen (Pen.join #f))) c (? . 23)) ((c def c (c (? . 0) q SVGDC)) q (5327 . 8)) ((c def c (c (? . 0) q Region (Region.polygon #f))) c (? . 21)) ((c def c (c (? . 0) q DC (DC.line #f))) c (? . 24)) ((c def c (c (? . 0) q Bitmap (Bitmap.from_file #f))) q (16129 . 3)) ((c def c (c (? . 0) q Path)) q (12488 . 3)) ((c def c (c (? . 0) q DC (DC.point #f))) c (? . 24)) ((c def c (c (? . 0) q Rect (Rect.x #f))) c (? . 9)) ((c def c (c (? . 0) q DC (DC.Smoothing.unsmoothed #f))) c (? . 13)) ((c def c (c (? . 0) q Font)) q (8968 . 16)) ((c def c (c (? . 0) q Font (Font.Weight.heavy #f))) c (? . 10)) ((c def c (c (? . 0) q Font (Font.Weight.ultraheavy #f))) c (? . 10)) ((c def c (c (? . 0) q Pen (Pen.Join.miter #f))) c (? . 25)) ((c def c (c (? . 0) q Rect (Rect.width #f))) c (? . 9)) ((c def c (c (? . 0) q Brush (Brush.Style.cross_hatch #f))) c (? . 2)) ((c def c (c (? . 0) q Size (Size.width #f))) c (? . 11)) ((c def c (c (? . 0) q Pen (Pen.Cap.round #f))) c (? . 26)) ((c def c (c (? . 0) q Point)) c (? . 16)) ((c def c (c (? . 0) q Font (Font.hinting #f))) c (? . 1)) ((c def c (c (? . 0) q Font (Font.smoothing #f))) c (? . 1)) ((c def c (c (? . 0) q Font (Font.Weight.semibold #f))) c (? . 10)) ((c def c (c (? . 0) q Transformation (Transformation.yy #f))) c (? . 6)) ((c def c (c (? . 0) q Region (Region.path #f))) c (? . 21)) ((c def c (c (? . 0) q Font (Font.name #f))) c (? . 1)) ((c def c (c (? . 0) q Region (Region.subtract #f))) c (? . 27)) ((c def c (c (? . 0) q DC (DC.layered_transformation #f))) c (? . 3)) ((c def c (c (? . 0) q Font (Font.weight #f))) c (? . 1)) ((c def c (c (? . 0) q Region (Region.is_empty #f))) c (? . 28)) ((c def c (c (? . 0) q Font (Font.Kind.default #f))) c (? . 7)) ((c def c (c (? . 0) q Pen (Pen.none #f))) q (7220 . 3)) ((c def c (c (? . 0) q Color (Color.red #f))) c (? . 19)) ((c def c (c (? . 0) q RadialGradient (RadialGradient.circles #f))) c (? . 20)) ((c def c (c (? . 0) q Point (Point.zero #f))) c (? . 16)) ((c def c (c (? . 0) q Bitmap (Bitmap.has_alpha #f))) c (? . 15)) ((c def c (c (? . 0) q Pen (Pen.Style.transparent #f))) c (? . 8)) ((c def c (c (? . 0) q Font (Font.Kind.system #f))) c (? . 7)) ((c def c (c (? . 0) q Pen (Pen.cap #f))) c (? . 23)) ((c def c (c (? . 0) q PointLike rhombus/annot)) c (? . 16)) ((c def c (c (? . 0) q Font (Font.Smoothing rhombus/annot))) c (? . 29)) ((c def c (c (? . 0) q Brush (Brush.gradient #f))) c (? . 30)) ((c def c (c (? . 0) q PagedDC (PagedDC.end_page #f))) c (? . 5)) ((c def c (c (? . 0) q Font (Font.Style.italic #f))) c (? . 22)) ((c def c (c (? . 0) q DC (DC.path #f))) c (? . 24)) ((c def c (c (? . 0) q Rect (Rect.y #f))) c (? . 9)) ((c def c (c (? . 0) q Bitmap (Bitmap.depth #f))) c (? . 15)) ((c def c (c (? . 0) q Path (Path.arc #f))) c (? . 14)) ((c def c (c (? . 0) q Pen (Pen.Style.hilite #f))) c (? . 8)) ((c def c (c (? . 0) q DC (DC.TextCombine.kern #f))) c (? . 17)) ((c def c (c (? . 0) q Font (Font.Smoothing.unsmoothed #f))) c (? . 29)) ((c def c (c (? . 0) q Font (Font.Kind.symbol #f))) c (? . 7)) ((c def c (c (? . 0) q DC (DC.bitmap #f))) q (3582 . 13)) ((c def c (c (? . 0) q DC (DC.handle #f))) c (? . 31)) ((c def c (c (? . 0) q Color (Color.from_handle #f))) c (? . 40)) ((c def c (c (? . 0) q Bitmap (Bitmap.write #f))) q (15878 . 8)) ((c def c (c (? . 0) q Rect (Rect.height #f))) c (? . 9)) ((c def c (c (? . 0) q Path (Path.reset #f))) c (? . 36)) ((c def c (c (? . 0) q PaperSize (PaperSize.paper #f))) c (? . 32)) ((c def c (c (? . 0) q Font (Font.has_underline #f))) c (? . 1)) ((c def c (c (? . 0) q Path (Path.append #f))) q (14476 . 3)) ((c def c (c (? . 0) q Brush (Brush.Style.bdiagonal_hatch #f))) c (? . 2)) ((c def c (c (? . 0) q Region (Region.union #f))) c (? . 27)) ((c def c (c (? . 0) q Pen (Pen.style #f))) c (? . 23)) ((c def c (c (? . 0) q Pen)) q (6191 . 11)) ((c def c (c (? . 0) q Font (Font.Smoothing.partly_smoothed #f))) c (? . 29)) ((c def c (c (? . 0) q Transformation (Transformation.xx #f))) c (? . 6)) ((c def c (c (? . 0) q Path (Path.bounding_box #f))) q (14558 . 3)) ((c def c (c (? . 0) q PSDC)) q (4976 . 9)) ((c def c (c (? . 0) q Region (Region.xor #f))) c (? . 27)) ((c def c (c (? . 0) q DC rhombus/class)) q (0 . 3)) ((c def c (c (? . 0) q Brush (Brush.Style.crossdiag_hatch #f))) c (? . 2)) ((c def c (c (? . 0) q Color (Color.alpha #f))) c (? . 19)) ((c def c (c (? . 0) q DC (DC.BitmapOverlay.solid #f))) c (? . 33)) ((c def c (c (? . 0) q Color (Color.scale #f))) q (5923 . 3)) ((c def c (c (? . 0) q Brush)) q (7255 . 9)) ((c def c (c (? . 0) q Bitmap (Bitmap.backing_scale #f))) c (? . 15)) ((c def c (c (? . 0) q PagedDC (PagedDC.start_doc #f))) c (? . 5)) ((c def c (c (? . 0) q PointLike (PointLike.to_point #f))) c (? . 16)) ((c def c (c (? . 0) q Pen (Pen.Style.xor #f))) c (? . 8)) ((c def c (c (? . 0) q Pen (Pen.Cap.projecting #f))) c (? . 26)) ((c def c (c (? . 0) q Pen (Pen.Cap rhombus/annot))) c (? . 26)) ((c def c (c (? . 0) q SizeLike (SizeLike.to_size rhombus/annot))) c (? . 11)) ((c def c (c (? . 0) q Path (Path.move_to #f))) c (? . 39)) ((c def c (c (? . 0) q Font (Font.Weight.book #f))) c (? . 10)) ((c def c (c (? . 0) q DC (DC.width #f))) c (? . 34)) ((c def c (c (? . 0) q Brush (Brush.Style.vertical_hatch #f))) c (? . 2)) ((c def c (c (? . 0) q SizeLike rhombus/annot)) c (? . 11)) ((c def c (c (? . 0) q DC (DC.BitmapOverlay.opaque #f))) c (? . 33)) ((c def c (c (? . 0) q DC (DC.save_and_restore #f))) c (? . 35)) ((c def c (c (? . 0) q DC (DC.scale #f))) c (? . 4)) ((c def c (c (? . 0) q DC (DC.text #f))) q (3313 . 10)) ((c def c (c (? . 0) q Transformation)) c (? . 6)) ((c def c (c (? . 0) q Brush (Brush.Style.opaque #f))) c (? . 2)) ((c def c (c (? . 0) q Transformation (Transformation.xy #f))) c (? . 6)) ((c def c (c (? . 0) q Bitmap (Bitmap.height #f))) c (? . 15)) ((c def c (c (? . 0) q Pen (Pen.Style.dot_dash #f))) c (? . 8)) ((c def c (c (? . 0) q Rect (Rect.point #f))) c (? . 9)) ((c def c (c (? . 0) q Font (Font.Smoothing.default #f))) c (? . 29)) ((c def c (c (? . 0) q Region (Region.dc #f))) q (10948 . 3)) ((c def c (c (? . 0) q RectLike (RectLike.to_rect #f))) c (? . 9)) ((c def c (c (? . 0) q Brush (Brush.Style.horizontal_hatch #f))) c (? . 2)) ((c def c (c (? . 0) q Transformation (Transformation.transform #f))) c (? . 6)) ((c def c (c (? . 0) q Pen (Pen.Join.bevel #f))) c (? . 25)) ((c def c (c (? . 0) q DC (DC.ellipse #f))) c (? . 24)) ((c def c (c (? . 0) q Region (Region.ellipse #f))) c (? . 21)) ((c def c (c (? . 0) q Font (Font.Style rhombus/annot))) c (? . 22)) ((c def c (c (? . 0) q Bitmap (Bitmap.argb_pixels #f))) q (15389 . 9)) ((c def c (c (? . 0) q DC (DC.copy #f))) q (4012 . 5)) ((c def c (c (? . 0) q Path (Path.close #f))) c (? . 36)) ((c def c (c (? . 0) q Region (Region.arc #f))) c (? . 21)) ((c def c (c (? . 0) q DC (DC.Fill rhombus/annot))) c (? . 37)) ((c def c (c (? . 0) q Pen (Pen.Style.xor_dot_dash #f))) c (? . 8)) ((c def c (c (? . 0) q Pen (Pen.Style.xor_dot #f))) c (? . 8)) ((c def c (c (? . 0) q Brush (Brush.Style.solid #f))) c (? . 2)) ((c def c (c (? . 0) q Pen (Pen.width #f))) c (? . 23)) ((c def c (c (? . 0) q RectLike rhombus/annot)) c (? . 9)) ((c def c (c (? . 0) q DC (DC.Smoothing rhombus/annot))) c (? . 13)) ((c def c (c (? . 0) q Pen (Pen.stipple #f))) c (? . 23)) ((c def c (c (? . 0) q Size)) c (? . 11)) ((c def c (c (? . 0) q Font (Font.Weight.ultralight #f))) c (? . 10)) ((c def c (c (? . 0) q DC (DC.rounded_rectangle #f))) c (? . 24)) ((c def c (c (? . 0) q Size (Size.zero #f))) c (? . 11)) ((c def c (c (? . 0) q DC (DC.brush #f))) c (? . 3)) ((c def c (c (? . 0) q LinearGradient (LinearGradient.line #f))) c (? . 38)) ((c def c (c (? . 0) q Transformation (Transformation.yx #f))) c (? . 6)) ((c def c (c (? . 0) q Brush (Brush.none #f))) q (8070 . 3)) ((c def c (c (? . 0) q Path (Path.curve_to #f))) c (? . 39)) ((c def c (c (? . 0) q Region (Region.Fill.odd_even #f))) c (? . 41)) ((c def c (c (? . 0) q Path (Path.scale #f))) c (? . 12)) ((c def c (c (? . 0) q DC (DC.Fill #f))) c (? . 37)) ((c def c (c (? . 0) q Color (Color.handle #f))) c (? . 40)) ((c def c (c (? . 0) q DC (DC.rectangle #f))) c (? . 24)) ((c def c (c (? . 0) q DC (DC.arc #f))) c (? . 24)) ((c def c (c (? . 0) q Pen (Pen.Style.dot #f))) c (? . 8)) ((c def c (c (? . 0) q DC (DC.save #f))) c (? . 35)) ((c def c (c (? . 0) q Font (Font.Weight.medium #f))) c (? . 10)) ((c def c (c (? . 0) q DC (DC.size #f))) c (? . 34)) ((c def c (c (? . 0) q RectLike (RectLike.to_rect rhombus/annot))) c (? . 9)) ((c def c (c (? . 0) q Bitmap (Bitmap.has_color #f))) c (? . 15)) ((c def c (c (? . 0) q Region (Region.Fill.winding #f))) c (? . 41)) ((c def c (c (? . 0) q Brush (Brush.stipple #f))) c (? . 30)) ((c def c (c (? . 0) q Path (Path.rectangle #f))) c (? . 14)) ((c def c (c (? . 0) q Path (Path.line_to #f))) c (? . 39)) ((c def c (c (? . 0) q Color (Color.blend #f))) q (6002 . 3)) ((c def c (c (? . 0) q Brush (Brush.Style rhombus/annot))) c (? . 2)) ((c def c (c (? . 0) q DC (DC.pen #f))) c (? . 3)) ((c def c (c (? . 0) q LinearGradient (LinearGradient.stops #f))) c (? . 38)) ((c def c (c (? . 0) q DC (DC.BitmapOverlay.xor #f))) c (? . 33)) ((c def c (c (? . 0) q Region (Region.Fill rhombus/annot))) c (? . 41)) ((c def c (c (? . 0) q Path (Path.is_open #f))) c (? . 36)) ((c def c (c (? . 0) q PDFDC)) q (5169 . 8)) ((c def c (c (? . 0) q Pen (Pen.Style.show_dash #f))) c (? . 8)) ((c def c (c (? . 0) q Brush (Brush.color #f))) c (? . 30)) ((c def c (c (? . 0) q DC (DC.TextCombine rhombus/annot))) c (? . 17)) ((c def c (c (? . 0) q Font (Font.size #f))) c (? . 1)) ((c def c (c (? . 0) q Bitmap (Bitmap.is_ok #f))) c (? . 15)) ((c def c (c (? . 0) q PagedDC (PagedDC.start #f))) c (? . 5)) ((c def c (c (? . 0) q DC (DC.lines #f))) c (? . 24)) ((c def c (c (? . 0) q Path (Path.ellipse #f))) c (? . 14)) ((c def c (c (? . 0) q Font (Font.Hinting.aligned #f))) c (? . 18)) ((c def c (c (? . 0) q Font (Font.features #f))) c (? . 1)) ((c def c (c (? . 0) q Pen (Pen.Style.long_dash #f))) c (? . 8)) ((c def c (c (? . 0) q Path (Path.rounded_rectangle #f))) c (? . 14)) ((c def c (c (? . 0) q DC (DC.clipping_region #f))) c (? . 3)) ((c def c (c (? . 0) q Pen (Pen.Join.round #f))) c (? . 25))))
interface

interface draw.DC
property

property (dc :: draw.DC).handle :: Any
 

fun draw.DC.from_handle(hand :: Any) :: DC
property

property (dc :: draw.DC).width :: NonnegReal
 

property (dc :: draw.DC).height :: NonnegReal
 

property (dc :: draw.DC).size :: Size
method

method (dc :: draw.DC).clear() :: Void
property

property
| (dc :: draw.DC).pen :: Pen
| (dc :: draw.DC).pen := (p :: Pen)
 

property
| (dc :: draw.DC).brush :: Brush
| (dc :: draw.DC).brush := (b :: Brush)
 

property
| (dc :: draw.DC).font :: Font
| (dc :: draw.DC).font := (f :: Font)
 

property
| (dc :: draw.DC).clipping_region :: maybe(Region)
| (dc :: draw.DC).clipping_region := (rgn :: maybe(Region))
 

property
| (dc :: draw.DC).transformation :: Transformation
| (dc :: draw.DC).transformation := (t :: Transformation)
 

property
| (dc :: draw.DC).layered_transformation :: LayeredTransformation
| (dc :: draw.DC).layered_transformation := (lt :: LayeredTransformation)
 

property
| (dc :: draw.DC).smoothing :: Smoothing
| (dc :: draw.DC).smoothing := (s :: Smoothing)
method

method (dc :: draw.DC).scale(s :: Real) :: Void
 

method (dc :: draw.DC).scale(sx :: Real, sy :: Real) :: Void
 

method (dc :: draw.DC).translate(dpt :: PointLike) :: Void
 

method (dc :: draw.DC).translate(dx :: Real, dy :: Real) :: Void
 

method (dc :: draw.DC).rotate(radians :: Real) :: Void
 

method (dc :: draw.DC).transform(t :: Transformation) :: Void
method

method (dc :: draw.DC).save() :: Void
 

method (dc :: draw.DC).restore() :: Void
 

dot (dc :: draw.DC).save_and_restore:
  body
  ...
method

method (dc :: draw.DC).point(pt :: PointLike)
  :: Void
 

method (dc :: draw.DC).line(pt1 :: PointLike,
                            pt2 :: PointLike)
  :: Void
 

method (dc :: draw.DC).lines(
  [pt :: PointLike, ...],
  ~dpt: dpt :: PointLike = Point.zero,
  ~dx: dx :: Real = 0,
  ~dy: dy :: Real = 0
) :: Void
 

method (dc :: draw.DC).polygon(
  [pt :: PointLike, ...],
  ~dpt: dpt :: PointLike = Point.zero,
  ~dx: dx :: Real = 0,
  ~dy: dy :: Real = 0,
  ~fill: fill :: DC.Fill = #'even_odd
) :: Void
 

method (dc :: draw.DC).rectangle(r :: RectLike)
  :: Void
 

method (dc :: draw.DC).rounded_rectangle(r :: RectLike,
                                         radius :: Real = -0.25)
  :: Void
 

method (dc :: draw.DC).ellipse(r :: RectLike)
  :: Void
 

method (dc :: draw.DC).arc(r :: RectLike,
                           start :: Real, end :: Real)
  :: Void
 

method (dc :: draw.DC).path(p :: draw.Path,
                            ~dpt: dpt :: PointLike = Point.zero,
                            ~dx: dx :: Real = 0,
                            ~dy: dy :: Real = 0,
                            ~fill: fill :: DC.Fill = #'odd_even)
  :: Void
method

method (dc:: draw.DC).text(
  str :: String,
  ~dpt: dpt :: PointLike = Point.zero,
  ~dx: dx :: Real = 0,
  ~dy: dy :: Real = 0,
  ~combine: combine :: DC.TextCombine = #'kern,
  ~angle: angle :: Real = 0.0
) :: Void
method

method (dc :: draw.DC).bitmap(
  bm :: Bitmap,
  ~dpt: dpt :: PointLike = Point.zero,
  ~dx: dx :: Real = 0,
  ~dy: dy :: Real = 0,
  ~source: source :: RectLike:
             Rect(Point.zero, Bitmap.size(bm)),
  ~style: style :: DC.BitmapOverlay = #'solid,
  ~color: color :: Color = Color("black"),
  ~mask: mask :: maybe(Bitmap) = #false,
) :: Void
method

method (dc :: draw.DC).copy(source :: RectLike,
                            dest :: PointLike)
  :: Void
method

method (dc :: draw.DC).font_metrics_key() :: Any
enumeration

enum draw.DC.Smoothing:
  unsmoothed
  aligned
  smoothed
enumeration

enum draw.DC.BitmapOverlay:
  solid
  opaque
  xor
enumeration

enum draw.DC.TextCombine:
  kern
  grapheme
  char
enumeration

enum draw.DC.Fill:
  even_odd
  winding
interface

interface draw.PagedDC
method

method (dc :: PagedDC).start(message :: String = "Printing")
  :: Void
 

method (dc :: PagedDC).end() :: Void
 

method (dc :: PagedDC).start_doc(message :: String = "Printing")
  :: Void
 

method (dc :: PagedDC).end_doc() :: Void
 

method (dc :: PagedDC).start_page() :: Void
 

method (dc :: PagedDC).end_page() :: Void
enumeration

enum PaperSize:
  ~is_a SizeLike
  paper
class

class draw.PSDC():
  implements PagedDC
  constructor (
    size :: PaperSize,
    ~output: output :: Path || Port.Output,
    ~as_eps: as_eps = #true
  )
class

class draw.PDFDC():
  implements PagedDC
  constructor (
    size :: PaperSize,
    ~output: output :: Path || Port.Output
  )
class

class draw.SVGDC():
  implements PagedDC
  constructor (
    size :: SizeLike,
    ~output: output :: Path || Port.Output
  )
class

class draw.Color():
  constructor
  | (name :: String)
  | (red :: Byte, green :: Byte, blue :: Byte)
  | (red :: Byte, green :: Byte, blue :: Byte, alpha :: Real.in(0.0, 1.0))
property

property (col :: draw.Color).red :: Byte
 

property (col :: draw.Color).green :: Byte
 

property (col :: draw.Color).blue :: Byte
 

property (col :: draw.Color).alpha :: Real.in(0, 1)
method

method (col :: draw.Color).scale(factor :: NonnegReal) :: Color
method

method (col :: draw.Color).blend(other :: Color) :: Color
property

property (col :: draw.Color).handle :: Any
 

fun draw.Color.from_handle(hand :: Any) :: Color
class

class draw.Pen():
  constructor (
    ~color: color :: (String || Color) = "Black",
    ~width: width :: Real.in(0, 255) = 1,
    ~style: style :: Pen.Style = #'solid,
    ~cap: cap :: Pen.Cap = #'round,
    ~join: join :: Pen.Join = #'round,
    ~stipple: stipple :: maybe(Bitmap) = #false,
  )
property

property (pen :: draw.Pen).color :: Color
 

property (pen :: draw.Pen).width :: Real.in(0, 255)
 

property (pen :: draw.Pen).style :: Pen.Style
 

property (pen :: draw.Pen).cap :: Pen.Cap
 

property (pen :: draw.Pen).join :: Pen.Join
 

property (pen :: draw.Pen).stipple :: maybe(Bitmap)
enumeration

enum draw.Pen.Style:
  transparent
  solid
  xor
  hilite
  dot
  long_dash
  show_dash
  dot_dash
  xor_dot
  xor_long_dot
  xor_short_dot
  xor_dot_dash
enumeration

enum draw.Pen.Cap:
  round
  projecting
  butt
enumeration

enum draw.Pen.Join:
  round
  bevel
  miter
value

def draw.Pen.none :: Pen
class

class draw.Brush():
  constructor (
    ~color: color :: (String || Color) = "Black",
    ~style: style :: Brush.Style = #'solid,
    ~stipple: stipple :: maybe(Bitmap) = #false,
    ~gradient: gradient :: maybe(LinearGradient || RadialGradient) = #false
  )
property

property (brush :: draw.Brush).color :: Color
 

property (brush :: draw.Brush).style :: Brush.Style
 

property (brush :: draw.Brush).stipple :: maybe(Bitmap)
 

property (brush :: draw.Brush).gradient
  :: maybe(LinearGradient || RadialGradient)
enumeration

enum draw.Brush.Style:
  transparent
  solid
  opaque
  xor
  hilite
  panel
  bdiagonal_hatch
  crossdiag_hatch
  fdiagonal_hatch
  cross_hatch
  horizontal_hatch
  vertical_hatch
value

def draw.Brush.none :: Brush
class

class draw.LinearGradient():
  constructor (pt1 :: PointLike,
               pt2 :: PointLike,
               [[stop :: Real.in(0.0, 1.0), color :: Color], ...])
 

property (grad :: draw.LinearGradient).line
  :: [Point, _ :: Point]
 

property (grad :: draw.LinearGradient).stops
  :: List.of([Real.in(0.0, 1.0), Color])
class

class draw.RadialGradient():
  constructor ([[pt1 :: PointLike], r1 :: Real],
               [[pt2 :: PointLike], r2 :: Real],
               [[stop :: Real.in(0.0, 1.0), color :: Color], ...])
 

property (grad :: draw.RadialGradient).circles
  :: [[PointLike, Real],
      [PointLike, Real]]
 

property (grad :: draw.RadialGradient).stops
  :: List.of([Real.in(0.0, 1.0), Color])
class

class draw.Font():
  constructor (
    ~kind: kind :: Font.Kind = #'default,
    ~name: name :: maybe(String) = #false,
    ~size: size :: Real.in(0.0, 1024.0) = 12.0,
    ~in_pixels: in_pixels :: Any = #false,
    ~style: style :: Font.Style = #'normal,
    ~weight: weight :: Font.Weight = #'normal,
    ~has_underline: has_underline :: Any = #false,
    ~smoothing: smoothing :: Font.Smoothing = #'default,
    ~hinting: hinting :: Font.Hinting = #'aligned,
    ~features:
      features :: Map.of(Font.FeatureString, Nat) = {},
  )
property

property (font :: draw.Font).kind :: Font.Kind
 

property (font :: draw.Font).name :: maybe(String)
 

property (font :: draw.Font).size :: Real.in(0.0, 1024.0)
 

property (font :: draw.Font).in_pixels :: Boolean
 

property (font :: draw.Font).style :: Font.Style
 

property (font :: draw.Font).weight :: Font.Weight
 

property (font :: draw.Font).has_underline :: Boolean
 

property (font :: draw.Font).smoothing :: Font.Smoothing
 

property (font :: draw.Font).hinting :: Font.Hinting
 

property (font :: draw.Font).features
  :: Map.of(Font.FeatureString, Nat)
annotation

draw.Font.FeatureString
enumeration

enum draw.Font.Kind:
  default
  decorative
  roman
  script
  swiss
  modern
  symbol
  system
enumeration

enum draw.Font.Style:
  normal
  slant
  italic
enumeration

enum draw.Font.Weight:
  ~is_a Int.in(100, 1000 ~inclusive)
  thin
  ultralight
  light
  semilight
  book
  normal
  medium
  semibold
  bold
  ultrabold
  heavy
  ultraheavy
enumeration

enum draw.Font.Smoothing:
  default
  partly_smoothed
  smoothed
  unsmoothed
enumeration

enum draw.Font.Hinting:
  aligned
  unaligned
class

class draw.Region():
  constructor (dc :: maybe(DC) = #false)
property

property (rgn :: draw.Region).dc :: maybe(DC)
method

method (rgn :: draw.Region).is_empty() :: Boolean
 

method (rgn :: draw.Region).contains(pt :: PointLike) :: Boolean
method

method (rgn :: draw.Region).polygon(
  [pt :: PointLike, ...],
  ~dpt: dpt :: PointLike = Point.zero,
  ~dx: dx :: Real = 0,
  ~dy: dy :: Real = 0,
  ~fill: fill :: Region.Fill = #'even_odd
) :: Void
 

method (rgn :: draw.Region).rectangle(r :: RectLike)
  :: Void
 

method (rgn :: draw.Region).rounded_rectangle(r :: RectLike,
                                              radius :: Real = -0.25)
  :: Void
 

method (rgn :: draw.Region).ellipse(r :: RectLike)
  :: Void
 

method (rgn :: draw.Region).arc(r :: RectLike,
                                start :: Real, end :: Real)
  :: Void
 

method (rgn :: draw.Region).path(
  p :: draw.Path,
  ~dpt: dpt :: PointLike = Point.zero,
  ~dx: dx :: Real = 0,
  ~dy: dy :: Real = 0,
  ~fill: fill :: Region.Fill = #'odd_even
) :: Void
method

method (rgn :: draw.Region).union(rgn2 :: Region) :: Void
 

method (rgn :: draw.Region).intersect(rgn2 :: Region) :: Void
 

method (rgn :: draw.Region).subtract(rgn2 :: Region) :: Void
 

method (rgn :: draw.Region).xor(rgn2 :: Region) :: Void
enumeration

enum draw.Region.Fill:
  odd_even
  winding
class

class draw.Path()
method

method (path :: draw.Path).close() :: Void
 

method (path :: draw.Path).is_open() :: Boolean
 

method (path :: draw.Path).reset() :: Void
method

method (path :: draw.Path).move_to(pt :: PointLike)
  :: Void
 

method (path :: draw.Path).line_to(pt :: PointLike)
  :: Void
 

method (path :: draw.Path).curve_to(pt1 :: PointLike,
                                    pt2 :: PointLike,
                                    pt3 :: PointLike)
  :: Void
method

method (path :: draw.Path).polygon(
  [pt :: PointLike, ...],
  ~dpt: dpt :: PointLike = Point.zero,
  ~dx: dx :: Real = 0,
  ~dy: dy :: Real = 0
) :: Void
 

method (path :: draw.Path).rectangle(r :: RectLike)
  :: Void
 

method (path :: draw.Path).rounded_rectangle(r :: RectLike,
                                             radius :: Real = -0.25)
  :: Void
 

method (path :: draw.Path).ellipse(r :: RectLike)
  :: Void
 

method (path :: draw.Path).arc(r :: RectLike,
                               start :: Real, end :: Real,
                               ~clockwise: clockwise :: Any = #false)
  :: Void
 

method (path :: draw.Path).text_outline(
  str :: String,
  ~dpt: dpt :: Point = Point.zero,
  ~dx: dx :: Real = 0,
  ~dy: dy :: Real = 0,
  ~font: font :: Font = Font(),
  ~combine: combine :: DC.TextCombine = #'kern
) :: Void
method

method (path :: draw.Path).scale(s :: Real) :: Void
 

method (path :: draw.Path).scale(sx :: Real, sy :: Real) :: Void
 

method (path :: draw.Path).rotate(radians :: Real) :: Void
 

method (path :: draw.Path).translate(dx :: Real, dy :: Real) :: Void
method

method (path :: draw.Path).append(other_path :: draw.Path) :: Void
method

method (path :: draw.Path).bounding_box() :: Rect
class

class draw.Bitmap():
  constructor (
    size :: SizeLike,
    ~backing_scale: backing_space :: Real.above(0.0) = 1,
    ~has_color: has_color :: Any = #true,
    ~has_alpha: has_alpha :: Any = #true,
  )
property

property (bm :: draw.Bitmap).width :: PosInt
 

property (bm :: draw.Bitmap).height :: PosInt
 

property (bm :: draw.Bitmap).size :: Size
 

property (bm :: draw.Bitmap).backing_scale :: Real.above(0.0)
 

property (bm :: draw.Bitmap).depth :: Nat
 

property (bm :: draw.Bitmap).has_color :: Boolean
 

property (bm :: draw.Bitmap).has_alpha :: Boolean
 

property (bm :: draw.Bitmap).is_ok :: Boolean
method

method (bm :: draw.Bitmap).make_dc() :: DC
method

method (bm :: draw.Bitmap).argb_pixels(
  ~x: x :: Nat = 0,
  ~y: y :: Nat = 0,
  ~width: width :: Nat = width,
  ~height: height :: Nat = height,
  ~dest: dest :: Bytes = Bytes.make(width * height * 4),
) :: Bytes
method

method (bm :: draw.Bitmap).set_argb_pixels(
  src :: Bytes,
  ~x: x :: Nat = 0,
  ~y: y :: Nat = 0,
  ~width: width :: Nat = width,
  ~height: height :: Nat = height,
) :: Void
method

method (bm :: draw.Bitmap).write(
  dest :: Path,
  ~kind: kind :: Any.of(#'png, #'jpeg, #'xbm, #'xpm, #'bmp),
  ~quality: quality :: Int.in(0, 100) = 75,
  ~as_unscaled: as_unscaled :: Any = #false,
) :: Void
function

fun draw.Bitmap.from_file(path :: String || Path) :: Bitmap
class

class draw.Point(x :: Real, y :: Real)
 

draw.PointLike
 

draw.PointLike.to_point
 

fun draw.PointLike.to_point(pt :: PointLike) :: Point
 

def draw.Point.zero :: Point = Point(0, 0)
class

class draw.Size(width :: NonnegReal, height :: NonnegReal)
 

draw.SizeLike
 

draw.SizeLike.to_size
 

fun draw.SizeLike.to_size(sz :: SizeLike) :: Size
 

def draw.Size.zero :: Size = Size(0, 0)
class

class draw.Rect(x :: Real, y :: Real,
                width :: NonnegReal, height :: NonnegReal):
  constructor
  | (x :: Real, y :: Real,
     width :: NonnegReal, height :: NonnegReal)
  | (point :: PointLike, size :: SizeLike)
 

property (r :: draw.Rect).point :: Point
 

property (r :: draw.Rect).size :: Size
 

draw.RectLike
 

draw.RectLike.to_rect
 

fun draw.RectLike.to_rect(sz :: RectLike) :: Rect
 

def draw.Rect.zero :: Rect = Rect(0, 0, 0, 0)
class

class draw.Transformation(xx :: Real, yx :: Real,
                          xy :: Real, yy :: Real,
                          x0 :: Real, y0 :: Real)
 

method (t :: Transformation).translate(dx :: Real, dy :: Real)
  :: Transformation
 

method (t :: Transformation).scale(sx :: Real, sy :: Real)
  :: Transformation
 

method (t :: Transformation).rotate(a :: Real)
  :: Transformation
 

method (t :: Transformation).transform(by_t :: Transformation)
  :: Transformation
annotation

draw.LayeredTransformation
